/***************************************************************************
 * This software written by Ufasoft  http://www.ufasoft.com                *
 * It is Public Domain and can be used in any Free or Commercial projects  *
 * with keeping these License lines in Help, Documentation, About Dialogs  *
 * and Source Code files, derived from this.                               *
 * ************************************************************************/

using System;
using System.IO;
using System.Threading;
using System.Net.Sockets;
using System.Collections;
using System.Collections.Generic;
using System.Net;
using System.Web;
using System.Data;
using System.Security.Cryptography;
using System.Net.Mail;
using System.Text;
using System.Text.RegularExpressions;

using MySql.Data.MySqlClient;

using Utils;



namespace Nntp {

	public class NntpPhpbb : NntpServer {
		MySqlConnection m_conn;

		public string Server = "127.0.0.1";
		public string Database = "phpbb";
		public string DbLogin;
		public string DbPassword;
		public string RemoteHost;


		string itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";


		string _hash_encode64(byte[] input, int count)
		{
			StringBuilder output = new StringBuilder();
			int i = 0;

			do
			{
				int value = input[i++];
				output.Append((char)itoa64[value & 0x3f]);

				if (i < count)
				{
					value |= input[i] << 8;
				}

				output.Append((char)itoa64[(value >> 6) & 0x3f]);

				if (i++ >= count)
					break;

				if (i < count)
				{
					value |= input[i] << 16;
				}

				output.Append((char)itoa64[(value >> 12) & 0x3f]);
				
				if (i++ >= count)
					break;

				output.Append((char)itoa64[(value >> 18) & 0x3f]);
			}
			while (i < count);

			return output.ToString();
		}


		string _hash_crypt_private(string password, string setting) {
			if (setting.Substring(0, 3) != "$H$")
				return null;
			int count_log2 = itoa64.IndexOf(setting[3]);
			if (count_log2 < 7 || count_log2 > 30)
				return null;
			int count = 1 << count_log2;
			string salt = setting.Substring(4, 8);
			if (salt.Length != 8)
				return null;
			var md5 = MD5.Create();
			byte[] pwdar = Encoding.UTF8.GetBytes(password);
			byte[] hash = md5.ComputeHash(Encoding.UTF8.GetBytes(salt + password));
			do
			{				
				byte[] ar = new byte[hash.Length + pwdar.Length];
				Array.Copy(hash, ar, hash.Length);
				Array.Copy(pwdar, 0, ar, hash.Length, pwdar.Length);
				hash = md5.ComputeHash(ar);
			}
			while (--count > 0) ;
			string output = setting.Substring(0, 12) + _hash_encode64(hash, 16);
			return output;
		}


		public NntpPhpbb() {
			Promt = "NNTP-PHPBB Server";
			//AuthRequired = true;
			ReadOnly = false;
		}

		public void Open() {
			string connStr = String.Format("server={0}; database={1}; user id={2}; password={3}; pooling=false",
				Server, Database, DbLogin, DbPassword);
			m_conn = new MySqlConnection(connStr);
			m_conn.Open();

			foreach (var g in GetLIST()) // Init group list
				GetGroup(g);

#if X_DEBUG
			User = OnAuth("ufasoft", "ercendo"); //!!!D
#endif

		
		}

		protected override NewsUser OnAuth(string login, string password) {
			using (IDbCommand c = m_conn.CreateCommand()) {
				c.CommandText = string.Format("SELECT user_id, user_password FROM users WHERE username='{0}'", login);
				using (IDataReader r = c.ExecuteReader()) {
					if (!r.Read())
						throw new NntpException(NntpStatusCode.AuthRejected);
					string hash = r.GetString(1);
					if (_hash_crypt_private(password, hash) != hash)
						throw new NntpException(NntpStatusCode.AuthRejected);
					var user = new NewsUser();
					user.Login = login;
					user.Password = password;
					user.Id = r.GetInt32(0);
					return user;
				}
			}
		}

		protected override IEnumerable<string> GetLIST() {
			var list = new List<string>();
			using (IDbCommand c = m_conn.CreateCommand()) {
				c.CommandText = "SELECT nntp_group_name FROM forums";
				using (IDataReader r = c.ExecuteReader()) {
					while (r.Read())
						list.Add(r.GetString(0));
				}
			}
			return list;
		}

		public override List<int> GetArticleIds(string groupname) {
			var list = new List<int>();
			using (IDbCommand c = m_conn.CreateCommand()) {
				c.CommandText = string.Format("SELECT post_id FROM posts WHERE forum_id=(SELECT forum_id FROM forums WHERE nntp_group_name='{0}')", groupname);
				using (IDataReader r = c.ExecuteReader()) {
					while (r.Read())
						list.Add(r.GetInt32(0));
				}
			}
			return list;
		}

		protected override IEnumerable<string> GetMessageIdsSince(DateTime dt, List<string> groupPatterns) {
			using (IDbCommand c = m_conn.CreateCommand()) {
				string cmd = "SELECT forum_id FROM forums WHERE ";
				bool bFirst = true;
				foreach (string p in groupPatterns) {
					if (p[0] != '!') {
						if (bFirst)
							cmd += "(";
						else
							cmd += " OR ";
						cmd += string.Format(" nntp_group_name='{0}'", p.Replace("*", "%"));
						bFirst = false;
					}
				}
				if (!bFirst)
					cmd += ")";
				foreach (string p in groupPatterns) {
					if (p[0] == '!') {
						if (!bFirst)
							cmd += " AND ";
						cmd += string.Format(" NOT nntp_group_name='{0}'", p.Substring(1).Replace("*", "%"));
					}
				}
				c.CommandText = string.Format("SELECT CONCAT('<', post_id, '@', F.nntp_group_name, '>') FROM posts LEFT JOIN forums F ON forum_id=F.forum_id WHERE forum_id IN ({0}) AND post_time >= {1}", cmd, Ut.DateTimeToUnix(dt));
				var list = new List<string>();
				using (IDataReader r = c.ExecuteReader()) {
					while (r.Read())
						list.Add(r.GetString(0));
				}
				return list;
			}
		}

		Dictionary<string, Newsgroup> Groups = new Dictionary<string, Newsgroup>();

		protected override Newsgroup GetGroup(string name) {
			Newsgroup g;
			if (Groups.TryGetValue(name, out g))
				return g;
			using (IDbCommand c = m_conn.CreateCommand()) {
				c.CommandText = string.Format(
					 " SELECT F.forum_id, COUNT(post_id), "
					+ "   IF(MIN(post_id) IS NULL, 0, MIN(post_id)),"
					+ "   IF(MAX(post_id) IS NULL, 0, MAX(post_id))"
					+" FROM forums F"
					+" LEFT JOIN posts P ON P.forum_id=F.forum_id"
					+" WHERE nntp_group_name='{0}' "
					+" GROUP BY F.forum_id",
					name);
				using (IDataReader r = c.ExecuteReader()) {
					if (!r.Read())
						throw new NntpException(NntpStatusCode.NoSuchGroup);
					g = new Newsgroup();
					g.NntpServer = this;
					g.Name = name;
					g.Id = r.GetInt32(0);
					g.EstimatedCount = r.GetInt32(1);
					g.First = r.GetInt32(2);
					g.Last = r.GetInt32(3);
					Groups[name] = g;
					return g;
				}
			}
		}

		static string HostName = Dns.GetHostName();

		NewsArticle GetArticle(IDataReader r) {
			var a = new NewsArticle();
			a.Newsgroup = GetGroup(r.GetString(9));
			a.Id = r.GetInt32(0);
			a.Author = r.GetString(1);
			string email = r.GetString(2);
			if (email != "")
				a.Author += " <" + email + ">";
			a.MessageId = string.Format("{0}@{1}", a.Id, HostName);
			a.Subject = r.GetString(3);
			a.Date = Ut.DateTimeFromUnix(r.GetInt64(4));
			a.Body = r.GetString(5);
			int topic_id = r.GetInt32(6);
			if (topic_id != a.Id)		//  to prevent using topic_id as article_id
				a.Refs.Add(topic_id.ToString() + "@" + HostName);
			a.LineCount = a.Body.Split(new char[] { '\n' }).Length;
			a.ByteCount = a.Body.Length;
			for (int i = 0; i < a.Body.Length; ++i)
				if (a.Body[i] == '\n')
					a.LineCount++;
			return a;
		}

		protected override NewsArticle GetArticle(Newsgroup g, int id) {
			using (IDbCommand c = m_conn.CreateCommand()) {
					c.CommandText = string.Format(
						"SELECT A.post_id, C.username, C.user_email,"
						+"CASE WHEN A.post_subject = '' THEN CONCAT('Re: ', E.topic_title) ELSE A.post_subject END,"
						+" A.post_time, A.post_text, A.topic_id, A.post_username, MIN(D.post_id), nntp_group_name "
						+"  FROM posts A "
						+"  INNER JOIN posts D ON D.topic_id=A.topic_id"
						+"  INNER JOIN topics E ON A.topic_id = E.topic_id"
						+"  LEFT JOIN users C ON A.poster_id=C.user_id"
						+"  LEFT JOIN forums F ON A.forum_id=F.forum_id"
						+ "  WHERE A.post_id={0} "
						+(g!=null ? " AND A.forum_id="+g.Id.ToString() : "")
						+"  GROUP BY D.topic_id", id);
					using (IDataReader r = c.ExecuteReader()) {
						if (!r.Read())
							throw new NntpException(NntpStatusCode.NoSuchArticle);
						return GetArticle(r);
					}
			}
		}

		protected override IEnumerable<NewsArticle> GetArticles(Newsgroup g, int first, int? last) {
			string cmd = string.Format(
				"SELECT A.post_id, C.username, C.user_email,"
				+ "CASE WHEN A.post_subject = '' THEN CONCAT('Re: ', E.topic_title) ELSE A.post_subject END,"
				+ " A.post_time, A.post_text, A.topic_id, A.post_username, 'xxx', nntp_group_name"
				+ "  FROM posts A "
				+ "  INNER JOIN topics E ON A.topic_id = E.topic_id"
				+ "  LEFT JOIN users C ON A.poster_id=C.user_id"
				+ "  LEFT JOIN forums F ON A.forum_id=F.forum_id"
				+ "  WHERE A.forum_id={0} AND A.post_id>={1} "
				+ "  ", g.Id, first);
			if (last.HasValue)
				cmd += string.Format(" AND A.post_id<={0}", last);
			using (IDbCommand c = m_conn.CreateCommand()) {
				c.CommandText = cmd;
				using (IDataReader r = c.ExecuteReader())
					while (r.Read())
						yield return GetArticle(r);
			}
		}

		protected override NewsArticle GetArticle(string msgid) {
			Regex re = new Regex(@"(.+)@(.+)");
			Match m = re.Match(msgid);
			if (!m.Success)
				throw new NntpException(NntpStatusCode.NoSuchArticleFound);
			return GetArticle(null, Convert.ToInt32(m.Groups[1].Value));
		}


		long ExecuteNonQuery(string sql) {
			using (MySqlCommand c = m_conn.CreateCommand()) {
				c.CommandText = sql;
				c.ExecuteNonQuery();
				return c.LastInsertedId;
			}
		}

		protected override void Post(MailMessageEx msg) {
			long topic_id;
			bool bHashRef = false;
			Match m = null;

			if (msg.Headers["References"] != null) {
				Regex re = new Regex(@".*<(\d+)@.+>");
				m = re.Match(msg.Headers["References"]);
				bHashRef = m.Success;
			}

			if (bHashRef) {
				int parid = Convert.ToInt32(m.Groups[1].Value);
				using (MySqlCommand c = m_conn.CreateCommand()) {
					c.CommandText = string.Format("SELECT topic_id FROM posts WHERE post_id={0}", parid);
					topic_id = Convert.ToInt32(c.ExecuteScalar());
				}
			}
			else {
				using (MySqlCommand c = m_conn.CreateCommand()) {
					c.CommandText = "INSERT INTO topics (forum_id, topic_title, topic_poster, topic_time, topic_status) "
						+"VALUES (?forum_id, ?topic_title, ?topic_poster, ?topic_time, 0)";
					c.Parameters.AddWithValue("?forum_id", SelectedGroup.Id);
					c.Parameters.AddWithValue("?topic_title", msg.Subject);
					c.Parameters.AddWithValue("?topic_poster", User.Id);
					c.Parameters.AddWithValue("?topic_time", Ut.DateTimeToUnix(DateTime.Now));
					c.ExecuteNonQuery();				
					topic_id = c.LastInsertedId;
				}
				ExecuteNonQuery(string.Format("UPDATE forums SET forum_topics=forum_topics+1 WHERE forum_id={0}", SelectedGroup.Id));
			}
	
			long post_id;
			using (MySqlCommand c = m_conn.CreateCommand()) {
				c.CommandText = "INSERT INTO posts (topic_id, forum_id, poster_id, post_time, poster_ip, post_subject, post_text) "
         				+" VALUES (?topic_id, ?forum_id, ?poster_id, ?post_time, ?poster_ip, ?post_subject, ?post_text)";

				c.Parameters.AddWithValue("?topic_id", topic_id);
				c.Parameters.AddWithValue("?forum_id", SelectedGroup.Id);
				c.Parameters.AddWithValue("?poster_id", User.Id);
				c.Parameters.AddWithValue("?post_time", Ut.DateTimeToUnix(DateTime.Now));
				c.Parameters.AddWithValue("?poster_ip", RemoteHost);
				c.Parameters.AddWithValue("?post_subject", msg.Subject);
				c.Parameters.AddWithValue("?post_text", msg.Body);
				c.ExecuteNonQuery();
				post_id = c.LastInsertedId;
			}
			ExecuteNonQuery(string.Format("UPDATE forums SET forum_posts=forum_posts+1, forum_last_post_id={0} WHERE forum_id={1}", post_id, SelectedGroup.Id));
			ExecuteNonQuery(string.Format("UPDATE users SET user_posts=user_posts+1 WHERE user_id={0}", User.Id));
			ExecuteNonQuery(string.Format("UPDATE topics SET topic_replies=topic_replies+1, topic_last_post_id={0} WHERE topic_id={1}", post_id, topic_id));
			ExecuteNonQuery(string.Format("UPDATE topics SET topic_first_post_id={0} WHERE topic_id={1} AND topic_first_post_id=0", post_id, topic_id));
		}

		protected override void OnCommand(string cmd, string args) {
			try {
				if (m_conn.State == ConnectionState.Closed)
					m_conn.Open();
			}
			catch (Exception) {
				var xx = new NntpException(NntpStatusCode.ProgramFault);
				WriteLine("{0} {1}", (int)xx.StatusCode, xx.Message);
				return;
			}

			base.OnCommand(cmd, args);
		}

	}



	public class ClassMain {

		static int Usage() {
			Console.Error.WriteLine("Usage:\n"
				  +"  nntp-phpbb [-h] [--daemon] [--log] [-s server] [-d database] user password\n"
				  +"    default server: 127.0.0.1\n"
				  +"    defult database: phpbb\n"
				  +"    --log - create protocol logs in /var/log/nntp\n"
				  +"    --daemon - daemon mode, listening socket\n"
				  );


			return 1;
		}

		static string dbName = "phpbb",
			dbHost = "127.0.0.1", dbLogin, dbPassword;

		static bool bLog = false;

		static NntpPhpbb CreateServer(TextReader r, TextWriter w) {
			var server = new NntpPhpbb();
			server.Database = dbName;
			server.Server = dbHost;
			server.DbLogin = dbLogin;
			server.DbPassword = dbPassword;

			if (bLog) {				
				var logger = new LineProtocolLogger(r, w);
				logger.Dir = "/var/log/nntp";
				server.Reader = logger.Reader;
				server.Writer = logger.Writer;
			}
			else {
				server.Reader = r;
				server.Writer = w;
			}
			return server;
		}

		public static int Main(string[] args) {			
			int idx = 0;
			bool bDaemon = false;
			for (; idx < args.Length; ++idx) {
				string arg = args[idx];
				if (arg[0] != '-')
					break;
				switch (arg) {
					case "-s":
						dbHost = args[++idx];
						break;
					case "-d":
						dbName = args[++idx];
						break;
					case "-h":
						Usage();
						return 0;
					case "--log":
						bLog = true;						
						break;
					case "--daemon":
						bDaemon = true;
						break;
					default:
						return Usage();
				}
			}
			if (idx + 2 != args.Length) {
				return Usage();
			}

			dbLogin = args[idx++];
			dbPassword = args[idx++];

			if (bDaemon) {
				var listener = new TcpListener(IPAddress.Any, 119);
				listener.Start();
				while (true) {
					var client = listener.AcceptTcpClient();
					new Thread(new ThreadStart(delegate() {
						NntpPhpbb server = CreateServer(new StreamReader(client.GetStream()), new StreamWriter(client.GetStream()));
						server.RemoteHost = (client.Client.RemoteEndPoint as IPEndPoint).Address.ToString();
						server.Open();
						server.Run();
					})).Start();
				}
			}
			else {
				NntpPhpbb server = CreateServer(Console.In, Console.Out);
				server.RemoteHost = Environment.GetEnvironmentVariable("REMOTE_HOST");
				server.Open();
				server.Run();
			}			
			return 0;
		}
	}
}
