﻿/***************************************************************************
 * This software written by Ufasoft  http://www.ufasoft.com                *
 * It is Public Domain and can be used in any Free or Commercial projects  *
 * with keeping these License lines in Help, Documentation, About Dialogs  *
 * and Source Code files, derived from this.                               *
 * ************************************************************************/

using System;
using System.IO;
using System.Net;

using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Utils {

	public class Rfc822DateTime {

		public const string Format = "dd MMM yyyy HH':'mm':'ss zz00";


		static public System.DateTime FromString(string date) {
			System.DateTime dt;
			int pos = date.LastIndexOf(" ");

			try {
				dt = Convert.ToDateTime(date);
				if (date.Substring(pos + 1) == "Z") {
					dt = dt.ToUniversalTime();
				}
				else if (date.Substring(pos + 1) == "GMT") {
					dt = dt.ToUniversalTime();
				}
				return dt;
			}
			catch (System.Exception x) {
				System.Diagnostics.Trace.WriteLine(x.Message);
			}

			dt = Convert.ToDateTime(date.Substring(0, pos));
			if (date[pos + 1] == '+') {
				int h = Convert.ToInt32(date.Substring(pos + 2, 2));
				dt = dt.AddHours(-h);
				int m = Convert.ToInt32(date.Substring(pos + 4, 2));
				dt = dt.AddMinutes(-m);
			}
			else if (date[pos + 1] == '-') {
				int h = Convert.ToInt32(date.Substring(pos + 2, 2));
				dt = dt.AddHours(h);
				int m = Convert.ToInt32(date.Substring(pos + 4, 2));
				dt = dt.AddMinutes(m);
			}
			else if (date.Substring(pos + 1) == "A") {
				dt = dt.AddHours(1);
			}
			else if (date.Substring(pos + 1) == "B") {
				dt = dt.AddHours(2);
			}
			else if (date.Substring(pos + 1) == "C") {
				dt = dt.AddHours(3);
			}
			else if (date.Substring(pos + 1) == "D") {
				dt = dt.AddHours(4);
			}
			else if (date.Substring(pos + 1) == "E") {
				dt = dt.AddHours(5);
			}
			else if (date.Substring(pos + 1) == "F") {
				dt = dt.AddHours(6);
			}
			else if (date.Substring(pos + 1) == "G") {
				dt = dt.AddHours(7);
			}
			else if (date.Substring(pos + 1) == "H") {
				dt = dt.AddHours(8);
			}
			else if (date.Substring(pos + 1) == "I") {
				dt = dt.AddHours(9);
			}
			else if (date.Substring(pos + 1) == "K") {
				dt = dt.AddHours(10);
			}
			else if (date.Substring(pos + 1) == "L") {
				dt = dt.AddHours(11);
			}
			else if (date.Substring(pos + 1) == "M") {
				dt = dt.AddHours(12);
			}
			else if (date.Substring(pos + 1) == "N") {
				dt = dt.AddHours(-1);
			}
			else if (date.Substring(pos + 1) == "O") {
				dt = dt.AddHours(-2);
			}
			else if (date.Substring(pos + 1) == "P") {
				dt = dt.AddHours(-3);
			}
			else if (date.Substring(pos + 1) == "Q") {
				dt = dt.AddHours(-4);
			}
			else if (date.Substring(pos + 1) == "R") {
				dt = dt.AddHours(-5);
			}
			else if (date.Substring(pos + 1) == "S") {
				dt = dt.AddHours(-6);
			}
			else if (date.Substring(pos + 1) == "T") {
				dt = dt.AddHours(-7);
			}
			else if (date.Substring(pos + 1) == "U") {
				dt = dt.AddHours(-8);
			}
			else if (date.Substring(pos + 1) == "V") {
				dt = dt.AddHours(-9);
			}
			else if (date.Substring(pos + 1) == "W") {
				dt = dt.AddHours(-10);
			}
			else if (date.Substring(pos + 1) == "X") {
				dt = dt.AddHours(-11);
			}
			else if (date.Substring(pos + 1) == "Y") {
				dt = dt.AddHours(-12);
			}
			else if (date.Substring(pos + 1) == "EST") {
				dt = dt.AddHours(5);
			}
			else if (date.Substring(pos + 1) == "EDT") {
				dt = dt.AddHours(4);
			}
			else if (date.Substring(pos + 1) == "CST") {
				dt = dt.AddHours(6);
			}
			else if (date.Substring(pos + 1) == "CDT") {
				dt = dt.AddHours(5);
			}
			else if (date.Substring(pos + 1) == "MST") {
				dt = dt.AddHours(7);
			}
			else if (date.Substring(pos + 1) == "MDT") {
				dt = dt.AddHours(6);
			}
			else if (date.Substring(pos + 1) == "PST") {
				dt = dt.AddHours(8);
			}
			else if (date.Substring(pos + 1) == "PDT") {
				dt = dt.AddHours(7);
			}

			return dt;
		}
	}
	
	public class Rfc822Message {
		public Encoding DefaultEncoding = Encoding.ASCII;
		public WebHeaderCollection Headers;
		public string Body;

		public static string GetEncoded(string s) {
			if (Ut.IsAscii(s))
				return s;
			Encoding enc = Encoding.UTF8;
			return string.Format("=?UTF-8?B?{1}?=", enc.EncodingName, Convert.ToBase64String(enc.GetBytes(s)));
		}

		public void Parse(Stream stm) {
			Headers = Ut.ReadHttpHeader(stm);

			string contType = Headers.Get("Content-Type");
			Encoding enc = DefaultEncoding;
			if (contType != null) {
				Match m = Regex.Match(contType, "charset=\"([^;]+)\"");
				if (m.Success)
					enc = Encoding.GetEncoding(m.Groups[1].Value);
			}
			byte[] bytes = Ut.ReadBytesToEnd(stm);
			if (Headers["Content-Transfer-Encoding"] == "base64")
				bytes = Convert.FromBase64String(Encoding.ASCII.GetString(bytes));
			Body = enc.GetString(bytes);
		}

		public string MessageId {
			get {
				string s = Headers["Message-ID"];
				if (s == null)
					return null;
				return Regex.Match(s, "<(.*)>").Groups[1].Value;
			}
		}

		public List<string> References {
			get {
				List<string> ar = new List<string>();
				string s = Headers["References"];
				if (s != null)
					foreach (Match m in Regex.Matches(s, "<([^>]+)>"))
						ar.Add(m.Groups[1].Value);
				return ar;
			}
		}

		public string Subject {
			get {
				byte[] ar = Encoding.GetEncoding(1252).GetBytes(Headers["Subject"]);
				return DefaultEncoding.GetString(ar);
			}
		}

		public DateTime Date {
			get {
				string s = Headers["Date"];
				return Rfc822DateTime.FromString(s);
			}
		}
	}
}

