using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Reflection;
using System.IO;
using Microsoft.Win32;
using System.Diagnostics;

using IWshRuntimeLibrary;

using Utils;
using Unet;

using App;

namespace Mess {
	public class DialogOptions : System.Windows.Forms.Form {
		private System.Windows.Forms.TabPage tabProxy;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnOk;
		private System.Windows.Forms.CheckBox cbRunOnStart;
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.TabPage pageGeneral;
		public ProxyUtils.PageProxy pageProxy;
		private System.Windows.Forms.CheckBox cbTopMost;
		private System.Windows.Forms.TabPage tabUpgrade;
		private Unet.ControlUpgrade pageUpgrade;
		private System.Windows.Forms.CheckBox cbUseTcp;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DialogOptions() {
			InitializeComponent();
		}

		protected override void Dispose(bool disposing) {
			if (disposing) {
				if (components != null) {
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOk = new System.Windows.Forms.Button();
			this.tabControl = new System.Windows.Forms.TabControl();
			this.pageGeneral = new System.Windows.Forms.TabPage();
			this.cbUseTcp = new System.Windows.Forms.CheckBox();
			this.cbTopMost = new System.Windows.Forms.CheckBox();
			this.cbRunOnStart = new System.Windows.Forms.CheckBox();
			this.tabProxy = new System.Windows.Forms.TabPage();
			this.pageProxy = new ProxyUtils.PageProxy();
			this.tabUpgrade = new System.Windows.Forms.TabPage();
			this.pageUpgrade = new Unet.ControlUpgrade();
			this.tabControl.SuspendLayout();
			this.pageGeneral.SuspendLayout();
			this.tabProxy.SuspendLayout();
			this.tabUpgrade.SuspendLayout();
			this.SuspendLayout();
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(192, 376);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "Cancel";
			// 
			// btnOk
			// 
			this.btnOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOk.Location = new System.Drawing.Point(96, 376);
			this.btnOk.Name = "btnOk";
			this.btnOk.TabIndex = 2;
			this.btnOk.Text = "Ok";
			// 
			// tabControl
			// 
			this.tabControl.Controls.Add(this.pageGeneral);
			this.tabControl.Controls.Add(this.tabProxy);
			this.tabControl.Controls.Add(this.tabUpgrade);
			this.tabControl.Location = new System.Drawing.Point(8, 8);
			this.tabControl.Name = "tabControl";
			this.tabControl.SelectedIndex = 0;
			this.tabControl.Size = new System.Drawing.Size(376, 360);
			this.tabControl.TabIndex = 0;
			// 
			// pageGeneral
			// 
			this.pageGeneral.Controls.Add(this.cbUseTcp);
			this.pageGeneral.Controls.Add(this.cbTopMost);
			this.pageGeneral.Controls.Add(this.cbRunOnStart);
			this.pageGeneral.Location = new System.Drawing.Point(4, 22);
			this.pageGeneral.Name = "pageGeneral";
			this.pageGeneral.Size = new System.Drawing.Size(368, 334);
			this.pageGeneral.TabIndex = 0;
			this.pageGeneral.Text = "General";
			this.pageGeneral.Click += new System.EventHandler(this.pageGeneral_Click);
			// 
			// cbUseTcp
			// 
			this.cbUseTcp.Location = new System.Drawing.Point(24, 120);
			this.cbUseTcp.Name = "cbUseTcp";
			this.cbUseTcp.TabIndex = 2;
			this.cbUseTcp.Text = "Use TCP only";
			this.cbUseTcp.Visible = false;
			// 
			// cbTopMost
			// 
			this.cbTopMost.Location = new System.Drawing.Point(24, 56);
			this.cbTopMost.Name = "cbTopMost";
			this.cbTopMost.Size = new System.Drawing.Size(256, 24);
			this.cbTopMost.TabIndex = 1;
			this.cbTopMost.Text = "Show window on &Top of desktop";
			// 
			// cbRunOnStart
			// 
			this.cbRunOnStart.Location = new System.Drawing.Point(24, 24);
			this.cbRunOnStart.Name = "cbRunOnStart";
			this.cbRunOnStart.Size = new System.Drawing.Size(256, 24);
			this.cbRunOnStart.TabIndex = 0;
			this.cbRunOnStart.Text = "&Run on Windows start";
			// 
			// tabProxy
			// 
			this.tabProxy.Controls.Add(this.pageProxy);
			this.tabProxy.Location = new System.Drawing.Point(4, 22);
			this.tabProxy.Name = "tabProxy";
			this.tabProxy.Size = new System.Drawing.Size(368, 334);
			this.tabProxy.TabIndex = 1;
			this.tabProxy.Text = "Proxy";
			// 
			// pageProxy
			// 
			this.pageProxy.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pageProxy.Location = new System.Drawing.Point(0, 0);
			this.pageProxy.Name = "pageProxy";
			this.pageProxy.Size = new System.Drawing.Size(368, 334);
			this.pageProxy.TabIndex = 0;
			// 
			// tabUpgrade
			// 
			this.tabUpgrade.Controls.Add(this.pageUpgrade);
			this.tabUpgrade.Location = new System.Drawing.Point(4, 22);
			this.tabUpgrade.Name = "tabUpgrade";
			this.tabUpgrade.Size = new System.Drawing.Size(368, 334);
			this.tabUpgrade.TabIndex = 2;
			this.tabUpgrade.Text = "Upgrade";
			// 
			// pageUpgrade
			// 
			this.pageUpgrade.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pageUpgrade.Location = new System.Drawing.Point(0, 0);
			this.pageUpgrade.Name = "pageUpgrade";
			this.pageUpgrade.Size = new System.Drawing.Size(368, 334);
			this.pageUpgrade.TabIndex = 0;
			// 
			// DialogOptions
			// 
			this.AcceptButton = this.btnOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(394, 414);
			this.Controls.Add(this.tabControl);
			this.Controls.Add(this.btnOk);
			this.Controls.Add(this.btnCancel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Name = "DialogOptions";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Options";
			this.Load += new System.EventHandler(this.DialogOptions_Load);
			this.Closed += new System.EventHandler(this.DialogOptions_Closed);
			this.tabControl.ResumeLayout(false);
			this.pageGeneral.ResumeLayout(false);
			this.tabProxy.ResumeLayout(false);
			this.tabUpgrade.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		public static void SetRunOnStart() {
			string path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.Startup), "UfasoftP2PMess.lnk");
			RegistryKey key = FormMain.UserAppRegistryKey.CreateSubKey("Options");//!!!
			object val = key.GetValue("RunOnStart");
			if (val == null || Convert.ToBoolean(val)) {
				key.SetValue("RunOnStart", 1);

				var shell = new WshShellClass();
				var shortcut = (IWshShortcut)shell.CreateShortcut(path);
				shortcut.TargetPath = Application.ExecutablePath;
				shortcut.Save();

//!!!				File.Copy(Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), "UfasoftP2PMess.lnk"), path, true);
			}
			else
				System.IO.File.Delete(path);
		}

		public static void DeleteRunOnStart() {
			System.IO.File.Delete(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.Startup), "UfasoftP2PMess.lnk"));
		}

		bool runOnStart;

		private void DialogOptions_Closed(object sender, System.EventArgs e) {
			if (DialogResult == DialogResult.OK) {
				pageProxy.SaveSettings();
				pageUpgrade.SaveSettings();
				RegistryKey key = FormMain.UserAppRegistryKey.OpenSubKey("Options", true);
				key.SetValue("RunOnStart", Convert.ToInt32(cbRunOnStart.Checked));
				key.SetValue("UseTcpOnly", Convert.ToInt32(cbUseTcp.Checked));
				if (cbRunOnStart.Checked != runOnStart)
					SetRunOnStart();
				RegistryKey keyLayout = FormMain.UserAppRegistryKey.CreateSubKey("Layout");
				keyLayout.SetValue("TopMost", Convert.ToInt32(FormMain.Instance.TopMost = cbTopMost.Checked));
			}
		}

		[Conditional("DEBUG")]
		void CheckDebug() {
			cbUseTcp.Visible = true;
		}

		private void DialogOptions_Load(object sender, System.EventArgs e) {
			CheckDebug();
			RegistryKey key = FormMain.UserAppRegistryKey.CreateSubKey("Options");
			runOnStart = cbRunOnStart.Checked = Convert.ToBoolean((int)key.GetValue("RunOnStart", 0));
			cbUseTcp.Checked = AppClass.GetUseTcp();
			cbTopMost.Checked = FormMain.Instance.TopMost;
		}

		private void pageGeneral_Click(object sender, System.EventArgs e) {

		}


	}
}
