using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using Microsoft.Win32;
using System.Diagnostics;
using System.Threading;
using System.Text.RegularExpressions;
using System.Net;
using System.ServiceProcess;

using Utils;
using ProxyUtils;
using Unet;
using Mess;

using App;

namespace Mess
{
	public class FormMain : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.ColumnHeader columnNick;
		private System.Windows.Forms.MenuItem menuExit;
		private System.ComponentModel.IContainer components;

		public UnetMan UnetMan = new UnetMan();
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem menuItem13;
		private System.Windows.Forms.MenuItem menuItem14;
		private System.Windows.Forms.ListView lvContactList;
		public System.Windows.Forms.ImageList imageList;
		private System.Windows.Forms.NotifyIcon notifyIcon;
		private System.Windows.Forms.MenuItem menuItem16;
		private System.Windows.Forms.MenuItem menuItem17;
		private System.Windows.Forms.MenuItem menuItem18;
		private System.Windows.Forms.MenuItem menuItem19;
		private System.Windows.Forms.MenuItem menuItem20;
		private System.Windows.Forms.MenuItem menuItem21;
		private System.Windows.Forms.MenuItem menuItem22;
		private System.Windows.Forms.MenuItem menuItem23;
		private System.Windows.Forms.ContextMenu menuTray;
		private System.Windows.Forms.MenuItem itemOpen;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuUser;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.Timer timer;
		private System.Windows.Forms.MenuItem menuItem15;
		private System.Windows.Forms.MenuItem menuItemHistory;
		private System.Windows.Forms.MenuItem menuExit2;
		private System.Windows.Forms.MainMenu menuMain;
		private System.Windows.Forms.ContextMenu menuContext;
		private System.Windows.Forms.MenuItem menuItemRename;
		private System.Windows.Forms.MenuItem menuItemProperties;
		private System.Windows.Forms.MenuItem menuItemHelp;
		private System.Windows.Forms.MenuItem menuItemAddToContactList;
		private System.Windows.Forms.MenuItem menuItemDelete;
		private System.Windows.Forms.MenuItem menuDebug;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem menuItem24;

		public FormLog FormLog = new FormLog();

		[Conditional("DEBUG")]
		void CreateGCBeep()
		{
			//!!!      new GCBeep();
		}

		[Conditional("DEBUG")]
		void ShowFormLog()
		{
			menuDebug.Visible = true;
			//!!!      FormLog.Show();
		}

		public FormMain()
		{
			InitializeComponent();
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code

		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormMain));
			this.menuMain = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuExit = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuUser = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem13 = new System.Windows.Forms.MenuItem();
			this.menuItem14 = new System.Windows.Forms.MenuItem();
			this.menuDebug = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.menuItem12 = new System.Windows.Forms.MenuItem();
			this.menuItem24 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItemHelp = new System.Windows.Forms.MenuItem();
			this.menuItem23 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem16 = new System.Windows.Forms.MenuItem();
			this.menuItem17 = new System.Windows.Forms.MenuItem();
			this.menuItem18 = new System.Windows.Forms.MenuItem();
			this.menuItem22 = new System.Windows.Forms.MenuItem();
			this.menuItem19 = new System.Windows.Forms.MenuItem();
			this.menuItem20 = new System.Windows.Forms.MenuItem();
			this.menuItem21 = new System.Windows.Forms.MenuItem();
			this.lvContactList = new System.Windows.Forms.ListView();
			this.columnNick = new System.Windows.Forms.ColumnHeader();
			this.menuContext = new System.Windows.Forms.ContextMenu();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem11 = new System.Windows.Forms.MenuItem();
			this.menuItemAddToContactList = new System.Windows.Forms.MenuItem();
			this.menuItemRename = new System.Windows.Forms.MenuItem();
			this.menuItemDelete = new System.Windows.Forms.MenuItem();
			this.menuItem15 = new System.Windows.Forms.MenuItem();
			this.menuItemHistory = new System.Windows.Forms.MenuItem();
			this.menuItemProperties = new System.Windows.Forms.MenuItem();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.notifyIcon = new System.Windows.Forms.NotifyIcon(this.components);
			this.menuTray = new System.Windows.Forms.ContextMenu();
			this.itemOpen = new System.Windows.Forms.MenuItem();
			this.menuExit2 = new System.Windows.Forms.MenuItem();
			this.timer = new System.Windows.Forms.Timer(this.components);
			this.SuspendLayout();
			// 
			// menuMain
			// 
			this.menuMain.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                             this.menuItem1,
                                                                             this.menuItem3,
                                                                             this.menuItem13,
                                                                             this.menuDebug,
                                                                             this.menuItem2});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                              this.menuExit});
			this.menuItem1.Text = "&File";
			this.menuItem1.Click += new System.EventHandler(this.menuItem1_Click);
			// 
			// menuExit
			// 
			this.menuExit.Index = 0;
			this.menuExit.Text = "E&xit";
			this.menuExit.Click += new System.EventHandler(this.menuExit_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                              this.menuUser,
                                                                              this.menuItem4});
			this.menuItem3.Text = "&User";
			// 
			// menuUser
			// 
			this.menuUser.Index = 0;
			this.menuUser.Text = "&Find";
			this.menuUser.Click += new System.EventHandler(this.menuUserFind_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 1;
			this.menuItem4.Text = "Change my &profile";
			this.menuItem4.Click += new System.EventHandler(this.menuCreateNewProfile_Click);
			// 
			// menuItem13
			// 
			this.menuItem13.Index = 2;
			this.menuItem13.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                               this.menuItem14});
			this.menuItem13.Text = "&Tools";
			// 
			// menuItem14
			// 
			this.menuItem14.Index = 0;
			this.menuItem14.Text = "&Options...";
			this.menuItem14.Click += new System.EventHandler(this.menuItem14_Click);
			// 
			// menuDebug
			// 
			this.menuDebug.Index = 3;
			this.menuDebug.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                              this.menuItem9,
                                                                              this.menuItem10,
                                                                              this.menuItem12,
                                                                              this.menuItem24});
			this.menuDebug.Text = "&Debug";
			this.menuDebug.Visible = false;
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 0;
			this.menuItem9.Text = "Show Active Peers";
			this.menuItem9.Click += new System.EventHandler(this.menuItem9_Click);
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 1;
			this.menuItem10.Text = "Show All Peers";
			this.menuItem10.Click += new System.EventHandler(this.menuItem10_Click);
			// 
			// menuItem12
			// 
			this.menuItem12.Index = 2;
			this.menuItem12.Text = "Query Version";
			this.menuItem12.Click += new System.EventHandler(this.menuItem12_Click);
			// 
			// menuItem24
			// 
			this.menuItem24.Index = 3;
			this.menuItem24.Text = "Query Stat";
			this.menuItem24.Click += new System.EventHandler(this.menuItem24_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 4;
			this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                              this.menuItemHelp,
                                                                              this.menuItem23,
                                                                              this.menuItem5});
			this.menuItem2.Text = "&Help";
			// 
			// menuItemHelp
			// 
			this.menuItemHelp.Index = 0;
			this.menuItemHelp.Text = "Help Topics";
			this.menuItemHelp.Click += new System.EventHandler(this.menuItemHelp_Click);
			// 
			// menuItem23
			// 
			this.menuItem23.Index = 1;
			this.menuItem23.Text = "-";
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 2;
			this.menuItem5.Text = "&About";
			this.menuItem5.Click += new System.EventHandler(this.menuItem5_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = -1;
			this.menuItem6.Text = "Create &New";
			// 
			// menuItem16
			// 
			this.menuItem16.Index = -1;
			this.menuItem16.Text = "-";
			// 
			// menuItem17
			// 
			this.menuItem17.Index = -1;
			this.menuItem17.Text = "Offline";
			// 
			// menuItem18
			// 
			this.menuItem18.Index = -1;
			this.menuItem18.Text = "Online";
			// 
			// menuItem22
			// 
			this.menuItem22.Index = -1;
			this.menuItem22.Text = "Free for chat";
			// 
			// menuItem19
			// 
			this.menuItem19.Index = -1;
			this.menuItem19.Text = "Invisible";
			// 
			// menuItem20
			// 
			this.menuItem20.Index = -1;
			this.menuItem20.Text = "DND";
			// 
			// menuItem21
			// 
			this.menuItem21.Index = -1;
			this.menuItem21.Text = "Away";
			// 
			// lvContactList
			// 
			this.lvContactList.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                                    this.columnNick});
			this.lvContactList.ContextMenu = this.menuContext;
			this.lvContactList.Dock = System.Windows.Forms.DockStyle.Fill;
			this.lvContactList.FullRowSelect = true;
			this.lvContactList.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.lvContactList.HideSelection = false;
			this.lvContactList.Location = new System.Drawing.Point(0, 0);
			this.lvContactList.Name = "lvContactList";
			this.lvContactList.Size = new System.Drawing.Size(292, 251);
			this.lvContactList.SmallImageList = this.imageList;
			this.lvContactList.TabIndex = 0;
			this.lvContactList.View = System.Windows.Forms.View.Details;
			this.lvContactList.KeyDown += new System.Windows.Forms.KeyEventHandler(this.lvContactList_KeyDown);
			this.lvContactList.Resize += new System.EventHandler(this.lvContactList_Resize);
			this.lvContactList.DoubleClick += new System.EventHandler(this.lvContactList_DoubleClick);
			this.lvContactList.AfterLabelEdit += new System.Windows.Forms.LabelEditEventHandler(this.lvContactList_AfterLabelEdit);
			this.lvContactList.SelectedIndexChanged += new System.EventHandler(this.lvContactList_SelectedIndexChanged);
			// 
			// columnNick
			// 
			this.columnNick.Text = "Nick";
			this.columnNick.Width = 50;
			// 
			// menuContext
			// 
			this.menuContext.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                this.menuItem7,
                                                                                this.menuItem8,
                                                                                this.menuItem11,
                                                                                this.menuItemAddToContactList,
                                                                                this.menuItemRename,
                                                                                this.menuItemDelete,
                                                                                this.menuItem15,
                                                                                this.menuItemHistory,
                                                                                this.menuItemProperties});
			this.menuContext.Popup += new System.EventHandler(this.contextMenu_Popup);
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 0;
			this.menuItem7.Shortcut = System.Windows.Forms.Shortcut.CtrlM;
			this.menuItem7.Text = "Message";
			this.menuItem7.Click += new System.EventHandler(this.menuItem7_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 1;
			this.menuItem8.Text = "File";
			// 
			// menuItem11
			// 
			this.menuItem11.Index = 2;
			this.menuItem11.Text = "-";
			// 
			// menuItemAddToContactList
			// 
			this.menuItemAddToContactList.Index = 3;
			this.menuItemAddToContactList.Text = "Add to contact list";
			this.menuItemAddToContactList.Click += new System.EventHandler(this.menuItemAddToContactList_Click);
			// 
			// menuItemRename
			// 
			this.menuItemRename.Index = 4;
			this.menuItemRename.Shortcut = System.Windows.Forms.Shortcut.F2;
			this.menuItemRename.Text = "Rename";
			this.menuItemRename.Click += new System.EventHandler(this.menuItemRename_Click);
			// 
			// menuItemDelete
			// 
			this.menuItemDelete.Index = 5;
			this.menuItemDelete.Shortcut = System.Windows.Forms.Shortcut.Del;
			this.menuItemDelete.Text = "Delete";
			this.menuItemDelete.Click += new System.EventHandler(this.menuItemDelete_Click);
			// 
			// menuItem15
			// 
			this.menuItem15.Index = 6;
			this.menuItem15.Text = "-";
			// 
			// menuItemHistory
			// 
			this.menuItemHistory.Index = 7;
			this.menuItemHistory.Text = "History";
			this.menuItemHistory.Click += new System.EventHandler(this.menuItemHistory_Click);
			// 
			// menuItemProperties
			// 
			this.menuItemProperties.Index = 8;
			this.menuItemProperties.Text = "Properties";
			this.menuItemProperties.Click += new System.EventHandler(this.menuItemProperties_Click);
			// 
			// imageList
			// 
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList.ImageStream")));
			this.imageList.TransparentColor = System.Drawing.Color.White;
			// 
			// notifyIcon
			// 
			this.notifyIcon.ContextMenu = this.menuTray;
			this.notifyIcon.Text = "P2P Messenger";
			this.notifyIcon.Visible = true;
			this.notifyIcon.DoubleClick += new System.EventHandler(this.notifyIcon_DoubleClick);
			// 
			// menuTray
			// 
			this.menuTray.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                             this.itemOpen,
                                                                             this.menuExit2});
			// 
			// itemOpen
			// 
			this.itemOpen.DefaultItem = true;
			this.itemOpen.Index = 0;
			this.itemOpen.Text = "Open";
			this.itemOpen.Click += new System.EventHandler(this.itemOpen_Click);
			// 
			// menuExit2
			// 
			this.menuExit2.Index = 1;
			this.menuExit2.Text = "Exit";
			this.menuExit2.Click += new System.EventHandler(this.menuExit_Click);
			// 
			// timer
			// 
			this.timer.Enabled = true;
			this.timer.Interval = 500;
			this.timer.Tick += new System.EventHandler(this.timer_Tick);
			// 
			// FormMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 251);
			this.Controls.Add(this.lvContactList);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Menu = this.menuMain;
			this.Name = "FormMain";
			this.ShowInTaskbar = false;
			this.Text = "Ufasoft P2P Messenger";
			this.Resize += new System.EventHandler(this.FormMain_Resize);
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FormMain_Closing);
			this.Load += new System.EventHandler(this.FormMain_Load);
			this.HelpRequested += new System.Windows.Forms.HelpEventHandler(this.FormMain_HelpRequested);
			this.Move += new System.EventHandler(this.FormMain_Move);
			this.Closed += new System.EventHandler(this.FormMain_Closed);
			this.VisibleChanged += new System.EventHandler(this.FormMain_VisibleChanged);
			this.ResumeLayout(false);

		}
		#endregion


		static Mutex mutex;

		[STAThread]
		static void Main()
		{
			foreach (string s in Environment.GetCommandLineArgs())
			{
				string u = s.ToUpper();
				if (u == "/REGSERVER" || u == "-REGSERVER")
				{
					DialogOptions.SetRunOnStart();
					return;
				}
				else if (u == "/UNREGSERVER" || u == "-UNREGSERVER")
				{
					DialogOptions.DeleteRunOnStart();
					return;
				}
			}
			bool b;
			mutex = new Mutex(false, "UfasoftMessenger", out b);
			if (!b)
				return;
			Application.Run(new FormMain());
		}


		public static FormMain Instance;

		public Messenger Messenger;

		ThreadMan ThreadMan = new ThreadMan();

		Upgrade Upgrade = new Upgrade();

		private void FormMain_Load(object sender, System.EventArgs e)
		{
			Instance = this;
			CreateGCBeep();
			Application.ApplicationExit += new EventHandler(Application_ApplicationExit);
			App.AppClass.FormMain = this;
			RegistryKey keyLayout = UserAppRegistryKey.CreateSubKey("Layout");
			try
			{
				m_visible = Convert.ToBoolean(keyLayout.GetValue("Visible", true));
				m_bounds = (Rectangle)Ut.FromData((byte[])keyLayout.GetValue("Bounds"));
				TopMost = Convert.ToBoolean(keyLayout.GetValue("TopMost"));
			}
			catch (Exception)
			{
				m_bounds = Bounds;
			}
			Bounds = m_bounds;  //!!!
			ShowFormLog();
			FormLog.StdOut.WriteLine("Starting P2P");

			//!!!      ThreadMan.Add(Upgrade);//!!!
			UnetMan.OnUseTcp += new UnetMan.UseTcpHandler(AppClass.GetUseTcp);
			UnetMan.OnGetProxy += new UnetMan.GetProxyHandler(AppClass.GetProxy);

			try {
				ThreadMan.Add(UnetMan);//!!!			
				Messenger = new Messenger(UnetMan);
				//!!!UnetMan.Create();
				Messenger.Create();
				if (Messenger.AccountMan.Profile == null)
					if (!CreateNewProfile())
						Close();
				Logger.Log("FormMain: before SetState");
				Messenger.SetState(AccountState.Online);
				m_bUpdateView = true;
				UpdateView();
				Logger.Log("FormMain: Updated View");
				Messenger.OnChangeContactState += new Messenger.ChangeContactStateHandler(OnChangeContactState);
			}
			catch (Exception x) {
				MessageBox.Show(x.Message, "P2P Messenger", MessageBoxButtons.OK, MessageBoxIcon.Error);
				Environment.ExitCode = 1;
				Application.Exit();
			}

			var svc = new ServiceController("SSDPSRV");
			if (svc.Status != ServiceControllerStatus.Running) {
				MessageBox.Show("SSDP service not runned.\nIt it recommended to run it to find your LAN neighbors");
			}
		}

		private void FormMain_Closed(object sender, System.EventArgs e)
		{
			RegistryKey keyLayout = UserAppRegistryKey.CreateSubKey("Layout");
			keyLayout.SetValue("Bounds", Ut.ObjToArray(m_bounds));
			keyLayout.SetValue("Visible", Convert.ToInt32(Visible));
		}

		bool CreateNewProfile()
		{
			FormAccountInfo d = new FormAccountInfo();
			if (d.ShowDialog(this) == DialogResult.OK)
			{
				Messenger.CreateAccount(d.AccountInfo);
				return true;
			}
			return false;
		}

		private void menuCreateNewProfile_Click(object sender, System.EventArgs e)
		{
			FormAccountInfo d = new FormAccountInfo();
			d.AccountInfo = Messenger.AccountMan.Profile.AccountInfo;
			if (d.ShowDialog(this) == DialogResult.OK)
			{
				d.UpdateAccountInfo();
				Messenger.AfterUpdateAccount();
			}
		}

		private void menuItem5_Click(object sender, System.EventArgs e)
		{
			(new DialogAbout()).ShowDialog(this);
		}

		public static RegistryKey UserAppRegistryKey
		{
			get
			{
				return Registry.CurrentUser.CreateSubKey(@"Software\Ufasoft\P2PMess");
			}
		}

		private void FormMain_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
		}

		private void menuItem14_Click(object sender, System.EventArgs e)
		{
			DialogOptions d = new DialogOptions();
			if (d.ShowDialog(this) == DialogResult.OK)
				UnetMan.UpdateSettings();
		}

		public FormUserList FormUserList;

		private void menuUserFind_Click(object sender, System.EventArgs e)
		{
			if (FormUserList == null)
			{
				FormUserList = new FormUserList();
				lock (Messenger)
				{
					Messenger.OnAccountInfo += new Messenger.AccountInfoHandler(FormUserList.OnAccountInfo);
					Messenger.InitialOnAccountInfo();
				}
			}
			FormUserList.Show();
			UnetMan.Relay(new QueryAccountInfoPacket());
			lock (Messenger)
				foreach (DictionaryEntry de in Messenger.Instance.AccountMan.HtAccount)
					UnetMan.Relay(new QueryAccountStatePacket(((DataForAccount)de.Value).AccountInfo));
		}

		private void menuItemDelete_Click(object sender, System.EventArgs e)
		{
			ListViewItem[] ar = new ListViewItem[lvContactList.SelectedItems.Count];
			lvContactList.SelectedItems.CopyTo(ar, 0);
			foreach (ListViewItem li in ar)
			{
				ContactViewInfo cvi = (ContactViewInfo)li.Tag;
				if (cvi.FormHistory != null)
					cvi.FormHistory.Close();
				if (cvi.FormReceivedMessage != null)
					cvi.FormReceivedMessage.Close();
				if (cvi.FormSendMessage != null)
					cvi.FormSendMessage.Close();
				lvContactList.Items.Remove(li);
				Messenger.DeleteFromProfile(cvi.ContactInfo);
			}
			UpdateView();//!!!
			Messenger.Save();
		}


		ContactViewInfo GetSelectedContactViewInfo()
		{
			return (ContactViewInfo)lvContactList.SelectedItems[0].Tag;
		}

		private void menuExit_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		bool m_visible;
		Rectangle m_bounds;

		private void FormMain_VisibleChanged(object sender, System.EventArgs e)
		{
			if (m_visible)
				m_bounds = Bounds;
			else
				Visible = false;
		}

		private void itemOpen_Click(object sender, System.EventArgs e)
		{
			m_visible = true;
			Show();
			WindowState = FormWindowState.Normal;
			bool prevTopMost = TopMost;
			TopMost = true;
			TopMost = prevTopMost;
		}

		void OnMoveOrResize()
		{
			if (WindowState == FormWindowState.Minimized)
				m_visible = false;
			if (m_visible)
				m_bounds = Bounds;
			else
				Visible = false;
		}

		private void FormMain_Move(object sender, System.EventArgs e)
		{
			OnMoveOrResize();
		}

		private void FormMain_Resize(object sender, System.EventArgs e)
		{
			OnMoveOrResize();
			switch (WindowState)
			{
				case FormWindowState.Minimized:
					if (FormLog != null)
						FormLog.Hide();
					break;
				default:
					if (FormLog != null)
						ShowFormLog();
					break;
			}
		}

		private void lvContactList_Resize(object sender, System.EventArgs e)
		{
			lvContactList.Columns[0].Width = lvContactList.ClientSize.Width - 1;
		}

		bool blinkShow;

		public static int GetStateImageIndex(AccountState state)
		{
			switch (state)
			{
				case AccountState.Online:
					return 0;
				case AccountState.Offline:
					return 1;
				case AccountState.Connecting:
					return 2;
				default:
					return 1;
			}
		}

		Image GetStateImage(AccountState state)
		{
			return imageList.Images[GetStateImageIndex(state)];
		}

		private void timer_Tick(object sender, System.EventArgs e)
		{
			blinkShow = !blinkShow;
			if (m_bUpdateView)
			{
				m_bUpdateView = false;
				UpdateView();
			}
		}

		private void menuItem7_Click(object sender, System.EventArgs e)
		{
			if (lvContactList.SelectedItems.Count != 0)
				SendMessage(GetSelectedContactViewInfo());
		}

		public void SendMessage(ContactViewInfo cvi)
		{
			if (cvi.FormSendMessage == null)
				(cvi.FormSendMessage = new FormSendMessage(cvi)).Show();
			cvi.FormSendMessage.Activate();
		}

		private void menuItemHistory_Click(object sender, System.EventArgs e)
		{
			ContactViewInfo cvi = GetSelectedContactViewInfo();
			if (cvi.FormHistory == null)
				(cvi.FormHistory = new FormHistory(cvi)).Show();
			cvi.FormHistory.Activate();
		}

		private void contextMenu_Popup(object sender, System.EventArgs e)
		{
			if (lvContactList.SelectedItems.Count == 0)
				foreach (MenuItem mi in menuContext.MenuItems)
					mi.Visible = false;
			else
			{
				ContactViewInfo cvi = GetSelectedContactViewInfo();
				menuItemAddToContactList.Visible = cvi.ContactInfo.Temporary;
			}
		}

		private void lvContactList_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			foreach (MenuItem mi in menuContext.MenuItems)
				mi.Visible = true;
		}

		public void UpdateView()
		{
			if (Messenger.AccountMan.Profile == null)
				return;
			Text = Messenger.AccountMan.Profile.AccountInfo.NickName;
			lock (this)
				lock (Messenger)
				{
					foreach (ContactInfo ci in Messenger.AccountMan.Profile.ContactList)
					{
						foreach (ListViewItem li in lvContactList.Items)
							if (ci == ((ContactViewInfo)li.Tag).ContactInfo)
								goto found;
						ListViewItem lvi = new ListViewItem(ci.NickName);
						ContactViewInfo cvi = new ContactViewInfo();
						cvi.ContactInfo = ci;
						lvi.Tag = cvi;
						lvContactList.Items.Add(lvi);
					found:
						;
					}
					bool messageWaits = false;
					foreach (ListViewItem li in lvContactList.Items)
					{
						ContactInfo ci = ((ContactViewInfo)li.Tag).ContactInfo;
						lock (Messenger)
						{
							if (ci.UnreadMessages.Count != 0)
								messageWaits = true;
							li.ImageIndex = blinkShow && ci.UnreadMessages.Count != 0 ? 3 : GetStateImageIndex(ci.AccountInfo.AccountState);
						}
					}
					Image image;
					if (blinkShow && messageWaits)
						image = imageList.Images[3];
					else
					{
						image = GetStateImage(Messenger.AccountMan.Profile.AccountInfo.AccountState);
						//!!!          if (Messenger.AccountMan.Profile.AccountInfo.State == AccountState.Connectinf)
						//!!!            image = imageList.Images[3];
					}
					notifyIcon.Icon = Icon.FromHandle(((Bitmap)image).GetHicon());
					if (messageWaits)
						m_bUpdateView = true;
					//!!!          if (!messageWaits && !blinkShow)
					//!!!            timer.Enabled = false;
				}
		}

		bool m_bUpdateView;

		public void OnChangeContactState(object o, EventArgs e)
		{
			m_bUpdateView = true;
		}

		ContactViewInfo GetWaitingContactInfo()
		{
			foreach (ListViewItem li in lvContactList.Items)
			{
				ContactViewInfo cvi = (ContactViewInfo)li.Tag;
				ContactInfo ci = cvi.ContactInfo;
				lock (Messenger)
					if (ci.UnreadMessages.Count != 0)
						return cvi;
			}
			return null;
		}

		void ShowReceivedMessage(ContactViewInfo cvi)
		{
			if (cvi.FormReceivedMessage == null)
			{
				ContactInfo ci = cvi.ContactInfo;
				MessageHistoryItem mhi;
				lock (Messenger)
				{
					mhi = (MessageHistoryItem)ci.UnreadMessages[0];
					ci.UnreadMessages.RemoveAt(0);
					ci.History.Add(mhi);
				}
				FormReceivedMessage f = cvi.FormReceivedMessage = new FormReceivedMessage(cvi);
				f.editText.Text = mhi.Text;
				f.labelFromNick.Text = ci.AccountInfo.NickName;
				f.labelDateTime.Text = mhi.DateTime.ToString();
				f.Show();
			}
		}

		private void notifyIcon_DoubleClick(object sender, System.EventArgs e)
		{
			ContactViewInfo cvi = GetWaitingContactInfo();
			if (cvi != null)
				ShowReceivedMessage(cvi);
			else
				itemOpen_Click(null, null);
		}

		private void lvContactList_DoubleClick(object sender, System.EventArgs e)
		{
			ContactViewInfo cvi = GetSelectedContactViewInfo(),
							cvd = cvi;
			ContactInfo ci = cvi.ContactInfo;
			lock (Messenger)
				if (ci.UnreadMessages.Count == 0)
					cvd = null;
			if (cvd != null)
				ShowReceivedMessage(cvd);
			else
				SendMessage(cvi);
		}

		private void menuItemProperties_Click(object sender, System.EventArgs e)
		{
			ContactViewInfo cvi = GetSelectedContactViewInfo();
			if (cvi.FormAccountInfo == null)
				(cvi.FormAccountInfo = new FormAccountInfo(cvi)).Show();
			cvi.FormAccountInfo.Activate();
		}

		private void menuItemRename_Click(object sender, System.EventArgs e)
		{
			if (lvContactList.SelectedItems.Count != 0)
			{
				lvContactList.LabelEdit = true;
				lvContactList.SelectedItems[0].BeginEdit();
				//!!!        lvContactList.LabelEdit = false;
			}
		}

		private void lvContactList_AfterLabelEdit(object sender, System.Windows.Forms.LabelEditEventArgs e)
		{
			lvContactList.LabelEdit = false;
			if (e.Label == "")
				e.CancelEdit = true;
			else
			{
				((ContactViewInfo)lvContactList.Items[e.Item].Tag).ContactInfo.NickName = e.Label;
				Messenger.Save();
			}
		}

		private void lvContactList_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.Alt && e.KeyCode == Keys.Enter)
				menuItemProperties_Click(null, null);
		}

		private void menuItemHelp_Click(object sender, System.EventArgs e)
		{
			Help.ShowHelpIndex(this, Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), "p2pmess.chm"));
		}

		private void FormMain_HelpRequested(object sender, System.Windows.Forms.HelpEventArgs hlpevent)
		{
			menuItemHelp_Click(null, null);
		}

		private void menuItem1_Click(object sender, System.EventArgs e)
		{

		}

		private void menuItemAddToContactList_Click(object sender, System.EventArgs e)
		{
			ContactViewInfo cvi = GetSelectedContactViewInfo();
			Messenger.AddToProfile(cvi.ContactInfo.AccountInfo);
			UpdateView();
			Messenger.Save();
		}

		void OnEndSession()
		{
			//!!!      FormMain_Closing(null,null);
			Application.Exit();
		}

		public bool ClosingApp;

		protected override void WndProc(ref System.Windows.Forms.Message m)
		{
			if (m.Msg == WinMsg.WM_QUERYENDSESSION)
			{
				m.Result = (IntPtr)1;

				//!!!        MessageBox.Show("WM_QUERYENDSESSION");
				//!!!        BeginInvoke(new SimpleDelegateHandler(OnEndSession));
			}
			else if (m.Msg == WinMsg.WM_ENDSESSION)
			{
				//        MessageBox.Show("Main WM_ENDSESSION");
				ClosingApp = true;
				if (FormUserList != null)
				{
					FormUserList.ClosingApp = true;
					FormUserList.Close();
				}
				FormLog.Close();
				FormMain_Closing(null, null);
				Application.Exit();
				//!!!        FormLog.Close();
				//!!!BeginInvoke(new SimpleDelegateHandler(OnEndSession));
			}
			else
				base.WndProc(ref m);
		}

		private void Application_ApplicationExit(object sender, EventArgs e)
		{
			Messenger.SetState(AccountState.Offline);
			ThreadMan.Stop();

			//!!!      UnetMan.Stop();
			//!!!      UnetMan = null;
			if (Messenger.AccountMan.Profile != null)
				Messenger.Save();
		}

		private void menuItem9_Click(object sender, System.EventArgs e)
		{
			UnetMan.ShowPeers(false);
		}

		private void menuItem10_Click(object sender, System.EventArgs e)
		{
			UnetMan.ShowPeers(true);
		}

		private void menuItem12_Click(object sender, System.EventArgs e)
		{
			UnetMan.QueryVersion();
		}

		private void menuItem24_Click(object sender, System.EventArgs e)
		{
			UnetMan.QueryStat();
		}
	}

	public class ContactViewInfo
	{
		public ContactInfo ContactInfo;
		public FormAccountInfo FormAccountInfo;
		public FormHistory FormHistory;
		public FormSendMessage FormSendMessage;
		public FormReceivedMessage FormReceivedMessage;
	}

	public class WinMsg
	{
		public const int WM_QUERYENDSESSION = 0x0011,
						 WM_ENDSESSION = 0x0016;
	}
}

namespace App
{
	public class AppClass
	{
		public static Mess.FormMain FormMain;

		public static RegistryKey UserAppRegistryKey
		{
			get
			{
				return Mess.FormMain.UserAppRegistryKey;
			}
		}

		public static Proxy GetProxy()
		{
			Proxy proxy = null;
			ProxyType proxyType = 0;
			RegistryKey appRegKey = UserAppRegistryKey,
			  key = null;
			if (appRegKey != null)
			{
				key = appRegKey.CreateSubKey("OptionsProxy");
				proxyType = (ProxyType)key.GetValue("ProxyType", 0);
			}
			switch (proxyType)
			{
				case ProxyType.Default:
					proxy = new IeProxy();
					break;
				case ProxyType.Http:
					proxy = new HttpProxy();
					break;
				case ProxyType.Socks4:
					proxy = new Socks4Proxy();
					break;
				case ProxyType.Socks5:
					proxy = new Socks5Proxy();
					break;
			}
			if (proxy != null & proxyType != ProxyType.Default)
			{
				proxy.HostPort = new HostPort();
				string host = key.GetValue("Host", "").ToString(); ;
				try
				{
					IPAddress ipaddr = IPAddress.Parse(host);
					proxy.HostPort.HostAddress = new Ip4HostAddress(ipaddr);
				}
				catch (Exception)
				{
					proxy.HostPort.HostAddress = new DomainHostAddress(host);
				}
				proxy.HostPort.Port = Convert.ToUInt16(key.GetValue("Port", "1080"));
				proxy.Login = key.GetValue("Login", "").ToString();
				proxy.Password = key.GetValue("Password", "").ToString();
			}
			return proxy;
		}

		public static StreamWriter StdOut
		{
			get
			{
				return FormLog.StdOut;
			}
		}

		public static void Exit()
		{
			FormMain.Instance.Close();
		}

		public static void OutMessage(object e)
		{
			FormLog.s_FormLog.MakeVisible = true;
			StdOut.WriteLine(e);
		}

		public static string ProductVersion
		{
			get
			{
				return Application.ProductVersion;
			}
		}

		public static bool GetUseTcp()
		{
			return Convert.ToBoolean((int)UserAppRegistryKey.CreateSubKey("Options").GetValue("UseTcpOnly", 1));
		}
	}

}

