using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.IO;


namespace EL
{
	public class Terminal : System.Windows.Forms.RichTextBox
	{
		private System.ComponentModel.Container components = null;

    internal MemoryStream memoryStream = new MemoryStream();

    private void timer_Tick(object sender, EventArgs e)
    {
      byte[] bar;
      lock (this)
      {
        if (memoryStream.Length == 0)
          return;
        bar = memoryStream.ToArray();
        memoryStream = new MemoryStream();
      }
      char[] ar = new char[bar.Length];
      for (int i=0; i<ar.Length; i++)
        ar[i] = (char)bar[i];
      string s = new string(ar,0,ar.Length);
      //if (!IsDisposed)//!!!
      {
        //!!!AppendText(s);
        string text = Text;
        if (text.Length > 1000)
          text = text.Substring(text.Length-1000);
        Text = text+s;
//!!!        ScrollDown();
      }
    }

    void OnStreamFlushHandler()
    {
    }

    internal void InvokeFlush()
    {
//!!!      if (this.IsHandleCreated)
//!!!        BeginInvoke(new SimpleDelegateHandler(OnStreamFlushHandler));
    }

    Timer timer = new Timer();

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

    LogStream logStream;
    StreamWriter streamWriter;

    public Terminal()
    {
      timer.Interval = 100;
      //!!!timer.Enabled = true;
      timer.Tick += new EventHandler(timer_Tick);
      logStream = new LogStream(this);
      (streamWriter = new StreamWriter(logStream)).AutoFlush = true;
      InitializeComponent();
    }

    public Stream Stream
    {
      get
      {
        return logStream;
      }
    }

    public StreamWriter StreamWriter
    {
      get
      {
        return streamWriter;
      }
    }

    public void ScrollDown()
    {
      this.Select(Text.Length,0);
      ScrollToCaret();
/*!!!      Message m = new Message();
      m.HWnd = this.Handle;
      int EM_SCROLL = 0xB5,
          SB_PAGEDOWN = 3;
      m.Msg = EM_SCROLL;
      m.WParam = new IntPtr(SB_PAGEDOWN);
      WndProc(ref m);*/
    }
    #region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{

    }
    #endregion

  }


  class LogStream : Stream
  {
    internal Terminal m_edit;

    internal LogStream(Terminal edit)
    {
      m_edit = edit;
    }

    public override void Write(byte[] buffer, int offset, int count)
    {
      if (m_edit.Visible)
        lock (m_edit)
          m_edit.memoryStream.Write(buffer,offset,count);
    }

    public override void Flush()
    {
      m_edit.InvokeFlush(); 
    }

    #region Overriden

    public override bool CanSeek
    {
      get
      {
        return true;
      }
    }

    public override long Seek(long offset, System.IO.SeekOrigin origin)
    {
      throw new NotImplementedException();
    }

    public override bool CanWrite
    {
      get
      {
        return true;
      }
    }

    public override long Length
    {
      get
      {
        return 0;
      }
    }

    public override long Position
    {
      get
      {
        return 0;
      }
      set
      {
      }
    }

    public override int Read(byte[] buffer, int offset, int count)
    {
      return 0;
    }

    public override bool CanRead
    {
      get
      {
        return true;
      }
    }

    public override void SetLength(long value)
    {
    
    }

    #endregion
  }

  delegate void SimpleDelegateHandler();


}
