using System;
using System.Threading;
using System.Net;
using System.Xml;
using System.Xml.XPath;
using System.IO;
using System.Windows.Forms;
using Microsoft.Win32;

using Utils;

namespace Unet
{
	public class Upgrade : IThreadable
	{
    string Ver, DownloadURL;

    UInt64 Parse(string s)
    {
      UInt64 r = 0;
      int idx = s.IndexOf(".");
      r += (UInt64)((long)UInt16.Parse(s.Substring(0,idx))<<48);
      int newidx = s.IndexOf(".",idx+1);
      if (newidx != -1)
        r += (UInt64)((long)UInt16.Parse(s.Substring(idx+1,newidx-idx-1))<<32);
      return r;
    }

    public static RegistryKey GetRegistryKey()
    {
      return Mess.FormMain.UserAppRegistryKey.OpenSubKey("Options",true);
    }

    protected override void VExecute()
    {
      Random random = new Random((int)DateTime.Now.Ticks); 
      if (random.Next() < Int32.MaxValue/2) //!!!
        return;

      if ((int)GetRegistryKey().GetValue("UpgradeNotify",1) == 0)
        return;

      string url = "http://www.ufasoft.com/xml/p2pmess.xml";
      WebRequest req = WebRequest.Create(url);
      WebResponse resp = req.GetResponse();
/*!!!        XmlTextReader r = new XmlTextReader(resp.GetResponseStream());
            StreamReader r = new StreamReader();*/

      Stream stm = resp.GetResponseStream();
      //!!!Stream stm = new FileStream(@"S:\SRC\WWW\Ufasoft\xml\p2pmess.xml",FileMode.Open,FileAccess.Read);
      XPathDocument doc = new XPathDocument(stm);
      XPathNavigator nav = doc.CreateNavigator();
      XPathNodeIterator it = nav.Select(nav.Compile("/XML_DIZ_INFO/Program_Info/Program_Version"));
      it.MoveNext();      
      Ver = it.Current.Value;
      it = nav.Select(nav.Compile("/XML_DIZ_INFO/Web_Info/Download_URLs/Primary_Download_URL"));
      it.MoveNext();
      DownloadURL = it.Current.Value;

      if (Parse(Ver) > Parse(Application.ProductVersion))
        MessageBox.Show("New version "+Ver+" available at "+DownloadURL);
    }

	}
}
