using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.IO;
using Microsoft.Win32;

using Unet;

namespace ProxyUtils
{

	public class PageProxy : System.Windows.Forms.UserControl
	{
    private System.Windows.Forms.GroupBox groupBox1;
    private System.Windows.Forms.RadioButton rbDirectly;
    private System.Windows.Forms.RadioButton rbSOCKS5;
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label label2;
    private System.Windows.Forms.TextBox editPort;
    private System.Windows.Forms.RadioButton rbHTTP;
    private System.Windows.Forms.Label label3;
    private System.Windows.Forms.Label label4;
    private System.Windows.Forms.RadioButton rbSOCKS4;
    private System.Windows.Forms.TextBox editHost;
    private System.Windows.Forms.TextBox editLogin;
    private System.Windows.Forms.TextBox editPassword;
		private System.Windows.Forms.RadioButton rbDefault;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public PageProxy()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitForm call

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.rbDefault = new System.Windows.Forms.RadioButton();
			this.rbSOCKS4 = new System.Windows.Forms.RadioButton();
			this.rbHTTP = new System.Windows.Forms.RadioButton();
			this.rbSOCKS5 = new System.Windows.Forms.RadioButton();
			this.rbDirectly = new System.Windows.Forms.RadioButton();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.editHost = new System.Windows.Forms.TextBox();
			this.editPort = new System.Windows.Forms.TextBox();
			this.editLogin = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.editPassword = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.rbDefault);
			this.groupBox1.Controls.Add(this.rbSOCKS4);
			this.groupBox1.Controls.Add(this.rbHTTP);
			this.groupBox1.Controls.Add(this.rbSOCKS5);
			this.groupBox1.Controls.Add(this.rbDirectly);
			this.groupBox1.Location = new System.Drawing.Point(24, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(224, 176);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "&Connect to internet";
			// 
			// rbDefault
			// 
			this.rbDefault.Location = new System.Drawing.Point(24, 16);
			this.rbDefault.Name = "rbDefault";
			this.rbDefault.Size = new System.Drawing.Size(152, 24);
			this.rbDefault.TabIndex = 0;
			this.rbDefault.Tag = "0";
			this.rbDefault.Text = "De&fault IE settings";
			// 
			// rbSOCKS4
			// 
			this.rbSOCKS4.Location = new System.Drawing.Point(24, 112);
			this.rbSOCKS4.Name = "rbSOCKS4";
			this.rbSOCKS4.Size = new System.Drawing.Size(152, 24);
			this.rbSOCKS4.TabIndex = 3;
			this.rbSOCKS4.Tag = "4";
			this.rbSOCKS4.Text = "Through SOCKS&4 proxy";
			this.rbSOCKS4.CheckedChanged += new System.EventHandler(this.rb_CheckedChanged);
			// 
			// rbHTTP
			// 
			this.rbHTTP.Location = new System.Drawing.Point(24, 80);
			this.rbHTTP.Name = "rbHTTP";
			this.rbHTTP.Size = new System.Drawing.Size(152, 24);
			this.rbHTTP.TabIndex = 2;
			this.rbHTTP.Tag = "2";
			this.rbHTTP.Text = "Through &HTTP proxy";
			this.rbHTTP.CheckedChanged += new System.EventHandler(this.rb_CheckedChanged);
			// 
			// rbSOCKS5
			// 
			this.rbSOCKS5.Location = new System.Drawing.Point(24, 144);
			this.rbSOCKS5.Name = "rbSOCKS5";
			this.rbSOCKS5.Size = new System.Drawing.Size(152, 24);
			this.rbSOCKS5.TabIndex = 4;
			this.rbSOCKS5.Tag = "5";
			this.rbSOCKS5.Text = "Through SOCKS&5 proxy";
			this.rbSOCKS5.CheckedChanged += new System.EventHandler(this.rb_CheckedChanged);
			// 
			// rbDirectly
			// 
			this.rbDirectly.Location = new System.Drawing.Point(24, 48);
			this.rbDirectly.Name = "rbDirectly";
			this.rbDirectly.Size = new System.Drawing.Size(152, 24);
			this.rbDirectly.TabIndex = 1;
			this.rbDirectly.Tag = "1";
			this.rbDirectly.Text = "&Directly";
			this.rbDirectly.CheckedChanged += new System.EventHandler(this.rb_CheckedChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(32, 200);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(64, 23);
			this.label1.TabIndex = 2;
			this.label1.Text = "&Server:";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(32, 232);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(56, 23);
			this.label2.TabIndex = 3;
			this.label2.Text = "&Port:";
			// 
			// editHost
			// 
			this.editHost.Location = new System.Drawing.Point(112, 200);
			this.editHost.Name = "editHost";
			this.editHost.TabIndex = 4;
			this.editHost.Text = "";
			// 
			// editPort
			// 
			this.editPort.Location = new System.Drawing.Point(112, 232);
			this.editPort.Name = "editPort";
			this.editPort.TabIndex = 5;
			this.editPort.Text = "1080";
			// 
			// editLogin
			// 
			this.editLogin.Location = new System.Drawing.Point(112, 272);
			this.editLogin.Name = "editLogin";
			this.editLogin.TabIndex = 7;
			this.editLogin.Text = "";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(32, 272);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(64, 23);
			this.label3.TabIndex = 6;
			this.label3.Text = "&User:";
			// 
			// editPassword
			// 
			this.editPassword.Location = new System.Drawing.Point(112, 304);
			this.editPassword.Name = "editPassword";
			this.editPassword.PasswordChar = '*';
			this.editPassword.TabIndex = 9;
			this.editPassword.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(32, 304);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(64, 23);
			this.label4.TabIndex = 8;
			this.label4.Text = "Pass&word:";
			// 
			// PageProxy
			// 
			this.Controls.Add(this.editPassword);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.editLogin);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.editPort);
			this.Controls.Add(this.editHost);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.groupBox1);
			this.Name = "PageProxy";
			this.Size = new System.Drawing.Size(320, 352);
			this.Load += new System.EventHandler(this.ProxyPage_Load);
			this.Validated += new System.EventHandler(this.ProxyPage_Validated);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		ProxyType m_proxyType;

		ProxyType ProxyType
		{
			get 
			{
				return m_proxyType;
			}

			set
			{
				m_proxyType = value;
				editPort.Enabled = editHost.Enabled = !rbDirectly.Checked && !rbDefault.Checked;
				editLogin.Enabled = rbSOCKS4.Checked || rbSOCKS5.Checked;
				editPassword.Enabled = rbSOCKS5.Checked;    
			}
		}

		bool loaded;

		RadioButton[] m_buttons;

		private void ProxyPage_Load(object sender, System.EventArgs e)
    {
			m_buttons = new RadioButton[] { rbDefault, rbDirectly, rbHTTP, null, rbSOCKS4, rbSOCKS5 };
      RegistryKey key = Mess.FormMain.UserAppRegistryKey.OpenSubKey("OptionsProxy");
			ProxyType proxyType = (ProxyType)key.GetValue("ProxyType",0);
			m_buttons[(int)proxyType].Checked = true;
			ProxyType = proxyType;
			loaded = true;
    }

		private void rb_CheckedChanged(object sender, System.EventArgs e)
		{
			foreach (RadioButton b in m_buttons)
				if (b!=null && b.Checked)
					ProxyType = (ProxyType)Convert.ToInt32(b.Tag);
		}

    public void SaveSettings()
    {
      if (loaded)
      {
        RegistryKey key = Mess.FormMain.UserAppRegistryKey.OpenSubKey("OptionsProxy",true);
        key.SetValue("ProxyType",(int)ProxyType);
        Proxy proxy = CreateProxyObject();
        if (proxy != null)
        {
          key.SetValue("Host",proxy.HostPort.HostAddress.ToString());
          key.SetValue("Port",proxy.HostPort.Port);
          key.SetValue("Login",proxy.Login);
          key.SetValue("Password",proxy.Password);
        }
      }
    }

    public EndPoint ReadSocks5Reply(BinaryReader r)
    {
      UInt16 rsv = r.ReadUInt16();
      byte frag = r.ReadByte(),
           atype = r.ReadByte();
      Int16 port;
      switch (atype)
      {
        case 1:
          Int32 host = r.ReadInt32();
          port = r.ReadInt16();
          return new IPEndPoint((UInt32)IPAddress.NetworkToHostOrder(host),IPAddress.NetworkToHostOrder(port));
        case 3:
          byte len = r.ReadByte();
          char[] p = r.ReadChars(len);
          port = r.ReadInt16();
          return new IPEndPoint(Dns.GetHostEntry(new string(p)).AddressList[0],IPAddress.NetworkToHostOrder(port));
        case 4:
          byte[] addr = r.ReadBytes(16);
          port = r.ReadInt16();
          throw new Exception("Address type not supported");
          //!!!
        default:
          throw new Exception("Address type not supported");
      }
    }

    public Proxy CreateProxyObject()
    {
      Proxy proxy = null;
      switch (ProxyType)
      {
        case ProxyType.Http:
          proxy = new HttpProxy();
          break;
        case ProxyType.Socks4:
          proxy = new Socks4Proxy();
          break;
        case ProxyType.Socks5:
          proxy = new Socks5Proxy();
          break;
      }
      if (proxy != null)
      {
        string host = editHost.Text;
        proxy.HostPort = new HostPort();
        try      
        {
          IPAddress ipaddr = IPAddress.Parse(host);
          proxy.HostPort.HostAddress = new Ip4HostAddress(ipaddr);
        }
        catch (Exception)
        {
          proxy.HostPort.HostAddress = new DomainHostAddress(host);
        }
        proxy.HostPort.Port = Convert.ToUInt16(editPort.Text);
        proxy.Login = editLogin.Text;
        proxy.Password = editPassword.Text;
      }
      return proxy;
    }

    private void ProxyPage_Validated(object sender, System.EventArgs e)
    {
    
    }

	}
}


