using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Mess
{
	public class FormAccountInfo : System.Windows.Forms.Form
	{
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label label2;
    public System.Windows.Forms.TextBox editEmail;
    private System.Windows.Forms.Button btnOk;
    private System.Windows.Forms.Button btnCancel;
    public System.Windows.Forms.TextBox editNickName;
    public System.Windows.Forms.TextBox editLastName;
    private System.Windows.Forms.Label label3;
    public System.Windows.Forms.TextBox editFirstName;
    private System.Windows.Forms.Label label4;
    private System.Windows.Forms.DateTimePicker dtpickerBirthdate;
    private System.Windows.Forms.Label label5;
    private System.Windows.Forms.Label label6;
    private System.Windows.Forms.ComboBox cbGender;
    private System.Windows.Forms.Label label7;
    private System.Windows.Forms.TextBox editCity;
    private System.Windows.Forms.Label label8;
    private System.Windows.Forms.ComboBox cbCountry;
		private System.ComponentModel.Container components = null;
    private System.Windows.Forms.Label label9;
    private System.Windows.Forms.TextBox editState;
    private System.Windows.Forms.Label label10;
    public System.Windows.Forms.TextBox editHomepage;

    public ContactViewInfo ContactViewInfo;

		public FormAccountInfo()
		{
			InitializeComponent();
      cbGender.SelectedIndex = 0;
		}

    public FormAccountInfo(ContactViewInfo cvi)
    {
      InitializeComponent();
      readOnly = true;
      cbGender.SelectedIndex = 0;
      ContactViewInfo = cvi;
    }

    public FormAccountInfo(AccountInfo ai)
    {
      InitializeComponent();
      readOnly = true;
      cbGender.SelectedIndex = 0;
      AccountInfo = ai;
    }

    protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
      this.btnOk = new System.Windows.Forms.Button();
      this.btnCancel = new System.Windows.Forms.Button();
      this.label1 = new System.Windows.Forms.Label();
      this.editNickName = new System.Windows.Forms.TextBox();
      this.label2 = new System.Windows.Forms.Label();
      this.editEmail = new System.Windows.Forms.TextBox();
      this.editLastName = new System.Windows.Forms.TextBox();
      this.label3 = new System.Windows.Forms.Label();
      this.editFirstName = new System.Windows.Forms.TextBox();
      this.label4 = new System.Windows.Forms.Label();
      this.dtpickerBirthdate = new System.Windows.Forms.DateTimePicker();
      this.label5 = new System.Windows.Forms.Label();
      this.label6 = new System.Windows.Forms.Label();
      this.cbGender = new System.Windows.Forms.ComboBox();
      this.label7 = new System.Windows.Forms.Label();
      this.editCity = new System.Windows.Forms.TextBox();
      this.label8 = new System.Windows.Forms.Label();
      this.cbCountry = new System.Windows.Forms.ComboBox();
      this.label9 = new System.Windows.Forms.Label();
      this.editState = new System.Windows.Forms.TextBox();
      this.label10 = new System.Windows.Forms.Label();
      this.editHomepage = new System.Windows.Forms.TextBox();
      this.SuspendLayout();
      // 
      // btnOk
      // 
      this.btnOk.DialogResult = System.Windows.Forms.DialogResult.OK;
      this.btnOk.Location = new System.Drawing.Point(95, 304);
      this.btnOk.Name = "btnOk";
      this.btnOk.TabIndex = 20;
      this.btnOk.Text = "OK";
      this.btnOk.Click += new System.EventHandler(this.btnOk_Click);
      // 
      // btnCancel
      // 
      this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
      this.btnCancel.Location = new System.Drawing.Point(295, 304);
      this.btnCancel.Name = "btnCancel";
      this.btnCancel.TabIndex = 21;
      this.btnCancel.Text = "Cancel";
      this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
      // 
      // label1
      // 
      this.label1.Location = new System.Drawing.Point(8, 16);
      this.label1.Name = "label1";
      this.label1.Size = new System.Drawing.Size(56, 23);
      this.label1.TabIndex = 0;
      this.label1.Text = "&Nick:";
      // 
      // editNickName
      // 
      this.editNickName.Location = new System.Drawing.Point(80, 16);
      this.editNickName.Name = "editNickName";
      this.editNickName.Size = new System.Drawing.Size(104, 20);
      this.editNickName.TabIndex = 1;
      this.editNickName.Text = "";
      // 
      // label2
      // 
      this.label2.Location = new System.Drawing.Point(8, 90);
      this.label2.Name = "label2";
      this.label2.Size = new System.Drawing.Size(56, 23);
      this.label2.TabIndex = 6;
      this.label2.Text = "&E-Mail:";
      // 
      // editEmail
      // 
      this.editEmail.Location = new System.Drawing.Point(80, 90);
      this.editEmail.Name = "editEmail";
      this.editEmail.Size = new System.Drawing.Size(104, 20);
      this.editEmail.TabIndex = 7;
      this.editEmail.Text = "";
      // 
      // editLastName
      // 
      this.editLastName.Location = new System.Drawing.Point(272, 53);
      this.editLastName.Name = "editLastName";
      this.editLastName.Size = new System.Drawing.Size(160, 20);
      this.editLastName.TabIndex = 5;
      this.editLastName.Text = "";
      // 
      // label3
      // 
      this.label3.Location = new System.Drawing.Point(208, 53);
      this.label3.Name = "label3";
      this.label3.Size = new System.Drawing.Size(56, 23);
      this.label3.TabIndex = 4;
      this.label3.Text = "&Last:";
      // 
      // editFirstName
      // 
      this.editFirstName.Location = new System.Drawing.Point(80, 53);
      this.editFirstName.Name = "editFirstName";
      this.editFirstName.Size = new System.Drawing.Size(104, 20);
      this.editFirstName.TabIndex = 3;
      this.editFirstName.Text = "";
      // 
      // label4
      // 
      this.label4.Location = new System.Drawing.Point(8, 53);
      this.label4.Name = "label4";
      this.label4.Size = new System.Drawing.Size(56, 23);
      this.label4.TabIndex = 2;
      this.label4.Text = "&First:";
      // 
      // dtpickerBirthdate
      // 
      this.dtpickerBirthdate.Location = new System.Drawing.Point(80, 127);
      this.dtpickerBirthdate.Name = "dtpickerBirthdate";
      this.dtpickerBirthdate.Size = new System.Drawing.Size(152, 20);
      this.dtpickerBirthdate.TabIndex = 11;
      this.dtpickerBirthdate.Value = new System.DateTime(1980, 1, 1, 0, 0, 0, 0);
      // 
      // label5
      // 
      this.label5.Location = new System.Drawing.Point(8, 127);
      this.label5.Name = "label5";
      this.label5.Size = new System.Drawing.Size(56, 23);
      this.label5.TabIndex = 10;
      this.label5.Text = "&Birth date:";
      // 
      // label6
      // 
      this.label6.Location = new System.Drawing.Point(8, 164);
      this.label6.Name = "label6";
      this.label6.Size = new System.Drawing.Size(48, 23);
      this.label6.TabIndex = 12;
      this.label6.Text = "&Gender:";
      // 
      // cbGender
      // 
      this.cbGender.Items.AddRange(new object[] {
                                                  "Not specified",
                                                  "Male",
                                                  "Female"});
      this.cbGender.Location = new System.Drawing.Point(80, 164);
      this.cbGender.Name = "cbGender";
      this.cbGender.Size = new System.Drawing.Size(80, 21);
      this.cbGender.TabIndex = 13;
      // 
      // label7
      // 
      this.label7.Location = new System.Drawing.Point(8, 238);
      this.label7.Name = "label7";
      this.label7.Size = new System.Drawing.Size(48, 23);
      this.label7.TabIndex = 18;
      this.label7.Text = "&City:";
      // 
      // editCity
      // 
      this.editCity.Location = new System.Drawing.Point(80, 238);
      this.editCity.Name = "editCity";
      this.editCity.TabIndex = 19;
      this.editCity.Text = "";
      // 
      // label8
      // 
      this.label8.Location = new System.Drawing.Point(8, 201);
      this.label8.Name = "label8";
      this.label8.Size = new System.Drawing.Size(56, 23);
      this.label8.TabIndex = 14;
      this.label8.Text = "Countr&y:";
      // 
      // cbCountry
      // 
      this.cbCountry.Items.AddRange(new object[] {
                                                   "Afghanistan",
                                                   "Albania",
                                                   "Algeria",
                                                   "American Samoa",
                                                   "Andorra",
                                                   "Angola",
                                                   "Anguilla",
                                                   "Antarctica",
                                                   "Antigua",
                                                   "Argentina",
                                                   "Armenia",
                                                   "Aruba",
                                                   "Australia",
                                                   "Austria",
                                                   "Azerbaijan",
                                                   "Bahamas",
                                                   "Bahrain",
                                                   "Bangladesh",
                                                   "Barbados",
                                                   "Belarus",
                                                   "Belgium",
                                                   "Belize",
                                                   "Benin",
                                                   "Bermuda",
                                                   "Bhutan",
                                                   "Bolivia",
                                                   "Bosnia and Herzegovina",
                                                   "Botswana",
                                                   "Brazil",
                                                   "British Virgin Islands",
                                                   "Brunei",
                                                   "Bulgaria",
                                                   "Burkina Faso",
                                                   "Burma",
                                                   "Burundi",
                                                   "Cambodia",
                                                   "Cameroon",
                                                   "Canada",
                                                   "Cape Verde",
                                                   "Central African Republic",
                                                   "Chad",
                                                   "Chile",
                                                   "China",
                                                   "Colombia",
                                                   "Comoros",
                                                   "Congo (Zaire)",
                                                   "Congo",
                                                   "Cook Islands",
                                                   "Costa Rica",
                                                   "Cote d\'Ivoire (Ivory Coast)",
                                                   "Croatia",
                                                   "Cuba",
                                                   "Cyprus",
                                                   "Czech Republic",
                                                   "Denmark",
                                                   "Djibouti",
                                                   "Dominica",
                                                   "Dominican Republic",
                                                   "Ecuador",
                                                   "Egypt",
                                                   "El Salvador",
                                                   "Equatorial Guinea",
                                                   "Eritrea",
                                                   "Estonia",
                                                   "Ethiopia",
                                                   "Falkland Islands",
                                                   "Fiji",
                                                   "Finland",
                                                   "France",
                                                   "French Guiana",
                                                   "French Polynesia",
                                                   "Gabon",
                                                   "The Gambia",
                                                   "Gaza Strip and West Bank",
                                                   "Georgia",
                                                   "Germany",
                                                   "Ghana",
                                                   "Gibraltar",
                                                   "Greece",
                                                   "Greenland",
                                                   "Grenada",
                                                   "Guadeloupe",
                                                   "Guam",
                                                   "Guatemala",
                                                   "Guinea",
                                                   "Guinea-Bissau",
                                                   "Guyana",
                                                   "Haiti",
                                                   "The Holy See",
                                                   "Honduras",
                                                   "Hong Kong",
                                                   "Hungary",
                                                   "Iceland",
                                                   "India",
                                                   "Indonesia",
                                                   "Iran",
                                                   "Iraq",
                                                   "Ireland",
                                                   "Israel",
                                                   "Italy",
                                                   "Ivory Coast (see Cote d\'Ivoire)",
                                                   "Jamaica",
                                                   "Japan",
                                                   "Jordan",
                                                   "Kazakhstan",
                                                   "Kenya",
                                                   "Kiribati",
                                                   "Kuwait",
                                                   "Kyrgyzstan",
                                                   "Laos",
                                                   "Latvia",
                                                   "Lebanon",
                                                   "Lesotho",
                                                   "Liberia",
                                                   "Libya",
                                                   "Liechtenstein",
                                                   "Lithuania",
                                                   "Luxembourg",
                                                   "Macau",
                                                   "Macedonia",
                                                   "Madagascar",
                                                   "Malawi",
                                                   "Malaysia",
                                                   "Maldives",
                                                   "Mali",
                                                   "Malta",
                                                   "Marshall Islands",
                                                   "Martinique",
                                                   "Mauritania",
                                                   "Mauritius",
                                                   "Mayotte",
                                                   "Mexico",
                                                   "Federated States of Micronesia",
                                                   "Moldova",
                                                   "Monaco",
                                                   "Mongolia",
                                                   "Montserrat",
                                                   "Morocco",
                                                   "Mozambique",
                                                   "Namibia",
                                                   "Nauru",
                                                   "Nepal",
                                                   "Netherlands",
                                                   "Netherlands Antilles",
                                                   "New Caledonia",
                                                   "New Zealand",
                                                   "Nicaragua",
                                                   "Niger",
                                                   "Nigeria",
                                                   "North Korea",
                                                   "Northern Mariana Islands",
                                                   "Norway",
                                                   "Oman",
                                                   "Pakistan",
                                                   "Palau",
                                                   "Panama",
                                                   "Papua New Guinea",
                                                   "Paraguay",
                                                   "Peru",
                                                   "Philippines",
                                                   "Pitcairn Islands",
                                                   "Poland",
                                                   "Portugal",
                                                   "Puerto Rico",
                                                   "Qatar",
                                                   "Reunion",
                                                   "Romania",
                                                   "Russia",
                                                   "Rwanda",
                                                   "Saint Kitts and Nevis",
                                                   "Saint Lucia",
                                                   "Saint Pierre and Miquelon",
                                                   "Saint Vincent and the Grenadines",
                                                   "Samoa",
                                                   "San Marino",
                                                   "Sao Tome and Principe",
                                                   "Saudi Arabia",
                                                   "Senegal",
                                                   "Serbia and Montenegro (Yugoslavia)",
                                                   "Seychelles",
                                                   "Sierra Leone",
                                                   "Singapore",
                                                   "Slovakia",
                                                   "Slovenia",
                                                   "Solomon Islands",
                                                   "Somalia",
                                                   "South Africa",
                                                   "South Korea",
                                                   "Spain",
                                                   "Sri Lanka",
                                                   "Sudan",
                                                   "Suriname",
                                                   "Swaziland",
                                                   "Sweden",
                                                   "Switzerland",
                                                   "Syria",
                                                   "Taiwan",
                                                   "Tajikistan",
                                                   "Tanzania",
                                                   "Thailand",
                                                   "Togo",
                                                   "Tonga",
                                                   "Trinidad and Tobago",
                                                   "Tunisia",
                                                   "Turkey",
                                                   "Turkmenistan",
                                                   "Turks and Caicos Islands",
                                                   "Tuvalu",
                                                   "Uganda",
                                                   "Ukraine",
                                                   "United Arab Emirates",
                                                   "United Kingdom",
                                                   "United States",
                                                   "United States Virgin Islands",
                                                   "Uruguay",
                                                   "Uzbekistan",
                                                   "Vanuatu",
                                                   "Venezuela",
                                                   "Vietnam",
                                                   "West Bank and Gaza Strip",
                                                   "Western Sahara",
                                                   "Yemen",
                                                   "Yugoslavia (see Serbia and Montenegro)",
                                                   "Zaire (see Congo)",
                                                   "Zambia",
                                                   "Zimbabwe"});
      this.cbCountry.Location = new System.Drawing.Point(80, 201);
      this.cbCountry.Name = "cbCountry";
      this.cbCountry.Size = new System.Drawing.Size(104, 21);
      this.cbCountry.TabIndex = 15;
      // 
      // label9
      // 
      this.label9.Location = new System.Drawing.Point(208, 201);
      this.label9.Name = "label9";
      this.label9.Size = new System.Drawing.Size(48, 23);
      this.label9.TabIndex = 16;
      this.label9.Text = "&State:";
      // 
      // editState
      // 
      this.editState.Location = new System.Drawing.Point(272, 201);
      this.editState.Name = "editState";
      this.editState.Size = new System.Drawing.Size(160, 20);
      this.editState.TabIndex = 17;
      this.editState.Text = "";
      // 
      // label10
      // 
      this.label10.Location = new System.Drawing.Point(200, 90);
      this.label10.Name = "label10";
      this.label10.Size = new System.Drawing.Size(64, 23);
      this.label10.TabIndex = 8;
      this.label10.Text = "&Homepage:";
      // 
      // editHomepage
      // 
      this.editHomepage.Location = new System.Drawing.Point(272, 90);
      this.editHomepage.Name = "editHomepage";
      this.editHomepage.Size = new System.Drawing.Size(160, 20);
      this.editHomepage.TabIndex = 9;
      this.editHomepage.Text = "";
      // 
      // FormAccountInfo
      // 
      this.AcceptButton = this.btnOk;
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.CancelButton = this.btnCancel;
      this.ClientSize = new System.Drawing.Size(464, 340);
      this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                  this.cbCountry,
                                                                  this.label8,
                                                                  this.editCity,
                                                                  this.label7,
                                                                  this.cbGender,
                                                                  this.label6,
                                                                  this.label5,
                                                                  this.dtpickerBirthdate,
                                                                  this.editFirstName,
                                                                  this.label4,
                                                                  this.editLastName,
                                                                  this.label3,
                                                                  this.editEmail,
                                                                  this.label2,
                                                                  this.editNickName,
                                                                  this.label1,
                                                                  this.btnCancel,
                                                                  this.btnOk,
                                                                  this.label9,
                                                                  this.editState,
                                                                  this.label10,
                                                                  this.editHomepage});
      this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
      this.Name = "FormAccountInfo";
      this.Text = "Account Info";
      this.Load += new System.EventHandler(this.DialogCreateProfile_Load);
      this.Closed += new System.EventHandler(this.FormAccountInfo_Closed);
      this.ResumeLayout(false);

    }
		#endregion

    private void DialogCreateProfile_Load(object sender, System.EventArgs e)
    {
      if (readOnly)
      {
        foreach (Control c in Controls)
          if (c is TextBox)
            ((TextBox)c).ReadOnly = true;
          else if (!(c is Button))
            c.Enabled = false;
      }
      if (ContactViewInfo != null)
        AccountInfo = ContactViewInfo.ContactInfo.AccountInfo;
    }

    AccountInfo ai;

    public void UpdateAccountInfo()
    {
      lock (Messenger.Instance)
      {
        ai.NickName   = editNickName.Text;
        ai.FirstName  = editFirstName.Text;
        ai.LastName   = editLastName.Text;
        ai.Birthday   = dtpickerBirthdate.Value;
        ai.Gender     = (AccountInfo.GenderEnum)cbGender.SelectedIndex;
        ai.Email      = editEmail.Text;
        ai.Homepage   = editHomepage.Text;
        ai.Country    = cbCountry.Text;
        ai.State      = editState.Text;
        ai.City       = editCity.Text;

        if (ai.Signature != null)
          ai.Sign();
      }
    }

    public AccountInfo AccountInfo
    {
      get
      {
        if (ai == null)
        {
          ai = new AccountInfo();
          UpdateAccountInfo();
        }
        return ai;
      }
      set
      {
        ai = value;
        lock (Messenger.Instance)
        {
          editNickName.Text       = ai.NickName;
          editFirstName.Text      = ai.FirstName;
          editLastName.Text       = ai.LastName;
          dtpickerBirthdate.Value = ai.Birthday;
          cbGender.SelectedIndex  = (int)ai.Gender;
          editEmail.Text          = ai.Email;
          editHomepage.Text       = ai.Homepage;
          cbCountry.Text          = ai.Country;
          editCity.Text           = ai.City;
          editState.Text          = ai.State;
        }
      }
    }

    bool readOnly;

    private void FormAccountInfo_Closed(object sender, System.EventArgs e)
    {
      if (ContactViewInfo != null)
        ContactViewInfo.FormAccountInfo = null; 
    }

    private void btnOk_Click(object sender, System.EventArgs e)
    {
      if (ReadOnly)
        Close();    
    }

    private void btnCancel_Click(object sender, System.EventArgs e)
    {
      if (ReadOnly)
        Close();    
    }

    public bool ReadOnly
    {
      get
      {
        return readOnly;
      }
      set
      {
        readOnly = value;
      }
    }
	}
}
