using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Mess
{
	public class FormHistory : System.Windows.Forms.Form
	{
    private System.Windows.Forms.ListView lv;
    private System.Windows.Forms.ColumnHeader columnHeader1;
    private System.Windows.Forms.ColumnHeader columnHeader2;
    private System.Windows.Forms.ColumnHeader columnHeader3;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

    public ContactViewInfo ContactViewInfo;

		public FormHistory(ContactViewInfo cvi)
		{
			InitializeComponent();
      
      ContactViewInfo = cvi;
      lock (ContactViewInfo.ContactInfo)
      {
        foreach (MessageHistoryItem mhi in ContactViewInfo.ContactInfo.History)
        {
          ListViewItem li = new ListViewItem();
          li.Text = mhi.DateTime.ToString();
          string nick = mhi.ReceivedItem ? ContactViewInfo.ContactInfo.AccountInfo.NickName
                                         : Messenger.Instance.AccountMan.Profile.AccountInfo.NickName;
          li.SubItems.Add(nick);
          li.SubItems.Add(mhi.Text);
          lv.Items.Add(li);
        }
      }
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
      this.lv = new System.Windows.Forms.ListView();
      this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
      this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
      this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
      this.SuspendLayout();
      // 
      // lv
      // 
      this.lv.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                         this.columnHeader1,
                                                                         this.columnHeader2,
                                                                         this.columnHeader3});
      this.lv.Dock = System.Windows.Forms.DockStyle.Fill;
      this.lv.Name = "lv";
      this.lv.Size = new System.Drawing.Size(292, 272);
      this.lv.TabIndex = 0;
      this.lv.View = System.Windows.Forms.View.Details;
      // 
      // columnHeader1
      // 
      this.columnHeader1.Text = "Date/Time";
      this.columnHeader1.Width = 113;
      // 
      // columnHeader2
      // 
      this.columnHeader2.Text = "Nick";
      // 
      // columnHeader3
      // 
      this.columnHeader3.Text = "Text";
      this.columnHeader3.Width = 200;
      // 
      // FormHistory
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(292, 272);
      this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                  this.lv});
      this.Name = "FormHistory";
      this.Text = "History";
      this.Load += new System.EventHandler(this.FormHistory_Load);
      this.Closed += new System.EventHandler(this.FormHistory_Closed);
      this.ResumeLayout(false);

    }
		#endregion

    private void FormHistory_Load(object sender, System.EventArgs e)
    {
    
    }

    private void FormHistory_Closed(object sender, System.EventArgs e)
    {
      ContactViewInfo.FormHistory = null;    
    }
	}
}
