using System; 
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;

using EL;
using Unet;

namespace Mess
{
	public class FormLog : System.Windows.Forms.Form
	{
    private Terminal editTerm;
    private System.Windows.Forms.TextBox inputLine;
    private System.Windows.Forms.Timer timer;
    private System.ComponentModel.IContainer components;

		public FormLog()
		{
      s_FormLog = this;    
      InitializeComponent();

      /*!!!
      LogStream stm = new LogStream();
      stm.m_edit = editTerm;
      stm.m_inputLine = inputLine;
      (StdStreamWriter = new StreamWriter(stm)).AutoFlush = true;*/
      StdStreamWriter = editTerm.StreamWriter;
    }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
      this.components = new System.ComponentModel.Container();
      System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FormLog));
      this.inputLine = new System.Windows.Forms.TextBox();
      this.editTerm = new EL.Terminal();
      this.timer = new System.Windows.Forms.Timer(this.components);
      this.SuspendLayout();
      // 
      // inputLine
      // 
      this.inputLine.Dock = System.Windows.Forms.DockStyle.Bottom;
      this.inputLine.Font = new System.Drawing.Font("Courier New", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
      this.inputLine.Location = new System.Drawing.Point(0, 310);
      this.inputLine.Name = "inputLine";
      this.inputLine.Size = new System.Drawing.Size(368, 22);
      this.inputLine.TabIndex = 1;
      this.inputLine.Text = "";
      this.inputLine.KeyDown += new System.Windows.Forms.KeyEventHandler(this.inputLine_KeyDown);
      this.inputLine.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.inputLine_KeyPress);
      // 
      // editTerm
      // 
      this.editTerm.Dock = System.Windows.Forms.DockStyle.Fill;
      this.editTerm.Font = new System.Drawing.Font("Courier New", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
      this.editTerm.Location = new System.Drawing.Point(0, 0);
      this.editTerm.Name = "editTerm";
      this.editTerm.ReadOnly = true;
      this.editTerm.Size = new System.Drawing.Size(368, 310);
      this.editTerm.TabIndex = 0;
      this.editTerm.Text = "";
      this.editTerm.TextChanged += new System.EventHandler(this.editTerm_TextChanged);
      this.editTerm.Enter += new System.EventHandler(this.editTerm_Enter);
      // 
      // timer
      // 
      this.timer.Interval = 1000;
      this.timer.Tick += new System.EventHandler(this.timer1_Tick);
      // 
      // FormLog
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(368, 332);
      this.Controls.Add(this.editTerm);
      this.Controls.Add(this.inputLine);
      this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
      this.MaximizeBox = false;
      this.Name = "FormLog";
      this.ShowInTaskbar = false;
      this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
      this.Text = "Terminal";
      this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.inputLine_KeyDown);
      this.Closing += new System.ComponentModel.CancelEventHandler(this.FormLog_Closing);
      this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.inputLine_KeyPress);
      this.Load += new System.EventHandler(this.FormLog_Load);
      this.VisibleChanged += new System.EventHandler(this.FormLog_VisibleChanged);
      this.ResumeLayout(false);

    }
		#endregion

    private void editTerm_Enter(object sender, System.EventArgs e)
    {
      //!!!inputLine.Focus();
    }

    public static FormLog s_FormLog;

    private void FormLog_Load(object sender, System.EventArgs e)
    {
    }

    static StreamWriter StdStreamWriter;

    public static StreamWriter StdOut
    {
      get
      {
        return StdStreamWriter;
      }
    }
    public static void Log(string s)
    {
      StdOut.WriteLine(s);
    }

    private void editTerm_TextChanged(object sender, System.EventArgs e)
    {      
    }

    ArrayList LineStack = new ArrayList();

    public virtual void OnEnterString(string s)
    {
      LineStack.Add(s);
      StdOut.WriteLine(s);
      UnetMan.Instance.OnCommand(s);
    }

    private void inputLine_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
    {
      switch (e.KeyCode)
      {
        case Keys.Up:
        {
          int count = LineStack.Count;
          if (count != 0)
          {
            inputLine.Text = (string)LineStack[count-1];
            LineStack.RemoveAt(count-1);
          }
        }
        break;
      }    
    }

    private void inputLine_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
    {
      if (e.KeyChar == '\r')
      {
        e.Handled = true;
        string s = inputLine.Text;
        inputLine.Text = "";
        OnEnterString(s);
      }    
    }

    public bool ClosingApp;

    protected override void WndProc(ref System.Windows.Forms.Message m)
    {
      if (m.Msg == WinMsg.WM_QUERYENDSESSION)
        m.Result = (IntPtr)1;
      else if (m.Msg == WinMsg.WM_ENDSESSION)
      {
        ClosingApp = true;
        Close();
      }
      else
        base.WndProc(ref m);
    }

    private void FormLog_Closing(object sender, System.ComponentModel.CancelEventArgs e)
    {
      if (!FormMain.Instance.ClosingApp)
      {
        e.Cancel = true;
        Hide();
      }
    }

    public bool MakeVisible;

    private void timer1_Tick(object sender, System.EventArgs e)
    {
      if (MakeVisible)
        Show();    
    }

    private void FormLog_VisibleChanged(object sender, System.EventArgs e)
    {
      timer.Enabled = Visible;
    }


	}

  


}


