using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Mess
{
	/// <summary>
	/// Summary description for F_SendMessage.
	/// </summary>
	public class FormSendMessage : System.Windows.Forms.Form
	{
    private System.Windows.Forms.Button buttonCancel;
    private System.Windows.Forms.Button buttonSend;
    private System.Windows.Forms.TextBox edit;
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.TextBox editNickTo;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

    public ContactViewInfo ContactViewInfo;

		public FormSendMessage(ContactViewInfo cvi)
		{
			InitializeComponent();

      ContactViewInfo = cvi;
      editNickTo.Text = ContactViewInfo.ContactInfo.NickName;    
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
      this.buttonCancel = new System.Windows.Forms.Button();
      this.buttonSend = new System.Windows.Forms.Button();
      this.edit = new System.Windows.Forms.TextBox();
      this.label1 = new System.Windows.Forms.Label();
      this.editNickTo = new System.Windows.Forms.TextBox();
      this.SuspendLayout();
      // 
      // buttonCancel
      // 
      this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
      this.buttonCancel.Location = new System.Drawing.Point(24, 216);
      this.buttonCancel.Name = "buttonCancel";
      this.buttonCancel.TabIndex = 2;
      this.buttonCancel.Text = "Cancel";
      this.buttonCancel.Click += new System.EventHandler(this.buttonCancel_Click);
      // 
      // buttonSend
      // 
      this.buttonSend.DialogResult = System.Windows.Forms.DialogResult.OK;
      this.buttonSend.Location = new System.Drawing.Point(240, 216);
      this.buttonSend.Name = "buttonSend";
      this.buttonSend.TabIndex = 1;
      this.buttonSend.Text = "Send";
      this.buttonSend.Click += new System.EventHandler(this.buttonSend_Click);
      // 
      // edit
      // 
      this.edit.AcceptsReturn = true;
      this.edit.Location = new System.Drawing.Point(8, 48);
      this.edit.Multiline = true;
      this.edit.Name = "edit";
      this.edit.Size = new System.Drawing.Size(328, 152);
      this.edit.TabIndex = 0;
      this.edit.Text = "";
      this.edit.KeyDown += new System.Windows.Forms.KeyEventHandler(this.edit_KeyDown);
      // 
      // label1
      // 
      this.label1.Location = new System.Drawing.Point(16, 8);
      this.label1.Name = "label1";
      this.label1.Size = new System.Drawing.Size(48, 23);
      this.label1.TabIndex = 3;
      this.label1.Text = "To:";
      // 
      // editNickTo
      // 
      this.editNickTo.Location = new System.Drawing.Point(96, 8);
      this.editNickTo.Name = "editNickTo";
      this.editNickTo.ReadOnly = true;
      this.editNickTo.Size = new System.Drawing.Size(104, 20);
      this.editNickTo.TabIndex = 4;
      this.editNickTo.Text = "";
      // 
      // FormSendMessage
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(346, 254);
      this.Controls.Add(this.editNickTo);
      this.Controls.Add(this.label1);
      this.Controls.Add(this.edit);
      this.Controls.Add(this.buttonSend);
      this.Controls.Add(this.buttonCancel);
      this.Name = "FormSendMessage";
      this.Text = "Send Message";
      this.Closed += new System.EventHandler(this.FormSendMessage_Closed);
      this.ResumeLayout(false);

    }
		#endregion

    private void FormSendMessage_Closed(object sender, System.EventArgs e)
    {
      ContactViewInfo.FormSendMessage = null;
      if (DialogResult == DialogResult.OK)
      { 
				try
				{
					Messenger.Instance.SendMessage(ContactViewInfo.ContactInfo,MessageText);
					Messenger.Instance.Save();
				}
				catch (Exception ex)
				{
					MessageBox.Show(ex.Message);
				}
      }
    }

    private void edit_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
    {
      if (e.KeyCode == Keys.Enter && e.Control)
      {
        DialogResult = DialogResult.OK;
        Close();
      }    
    }

    private void buttonSend_Click(object sender, System.EventArgs e)
    {
      Close();
    }

    private void buttonCancel_Click(object sender, System.EventArgs e)
    {
      Close();    
    }

    public string MessageText
    {
      get
      {
        return edit.Text;
      }
    }
	}
}
