using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Utils;
using Unet;

namespace Mess
{
	public class FormUserList : System.Windows.Forms.Form
	{
    private System.Windows.Forms.ListView lv;
    private System.Windows.Forms.ContextMenu contextMenu;
    private System.Windows.Forms.ColumnHeader columnHeader1;
    private System.Windows.Forms.ColumnHeader columnHeader2;
    private System.Windows.Forms.ColumnHeader columnHeader3;
    private System.Windows.Forms.ColumnHeader columnHeader4;
    private System.Windows.Forms.ColumnHeader columnHeader5;
    private System.Windows.Forms.MenuItem menuItemAdd;
    private System.Windows.Forms.MenuItem menuItemProperties;
    private System.Windows.Forms.Timer timer;
    private System.ComponentModel.IContainer components;

		public FormUserList()
		{
			InitializeComponent();

		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
      this.components = new System.ComponentModel.Container();
      this.lv = new System.Windows.Forms.ListView();
      this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
      this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
      this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
      this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
      this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
      this.contextMenu = new System.Windows.Forms.ContextMenu();
      this.menuItemAdd = new System.Windows.Forms.MenuItem();
      this.menuItemProperties = new System.Windows.Forms.MenuItem();
      this.timer = new System.Windows.Forms.Timer(this.components);
      this.SuspendLayout();
      // 
      // lv
      // 
      this.lv.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
                                                                         this.columnHeader5,
                                                                         this.columnHeader1,
                                                                         this.columnHeader2,
                                                                         this.columnHeader3,
                                                                         this.columnHeader4});
      this.lv.ContextMenu = this.contextMenu;
      this.lv.Dock = System.Windows.Forms.DockStyle.Fill;
      this.lv.FullRowSelect = true;
      this.lv.Location = new System.Drawing.Point(0, 0);
      this.lv.Name = "lv";
      this.lv.Size = new System.Drawing.Size(424, 276);
      this.lv.TabIndex = 0;
      this.lv.View = System.Windows.Forms.View.Details;
      this.lv.DoubleClick += new System.EventHandler(this.lv_DoubleClick);
      // 
      // columnHeader5
      // 
      this.columnHeader5.Text = "Date";
      // 
      // columnHeader1
      // 
      this.columnHeader1.Text = "Nick Name";
      this.columnHeader1.Width = 100;
      // 
      // columnHeader2
      // 
      this.columnHeader2.Text = "First Name";
      this.columnHeader2.Width = 100;
      // 
      // columnHeader3
      // 
      this.columnHeader3.Text = "Last Name";
      this.columnHeader3.Width = 100;
      // 
      // columnHeader4
      // 
      this.columnHeader4.Text = "E-Mail";
      this.columnHeader4.Width = 100;
      // 
      // contextMenu
      // 
      this.contextMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                this.menuItemAdd,
                                                                                this.menuItemProperties});
      // 
      // menuItemAdd
      // 
      this.menuItemAdd.Index = 0;
      this.menuItemAdd.Text = "&Add to Contact List";
      this.menuItemAdd.Click += new System.EventHandler(this.menuItemAdd_Click);
      // 
      // menuItemProperties
      // 
      this.menuItemProperties.Index = 1;
      this.menuItemProperties.Text = "Properties";
      this.menuItemProperties.Click += new System.EventHandler(this.menuItemProperties_Click);
      // 
      // timer
      // 
      this.timer.Enabled = true;
      this.timer.Interval = 1000;
      this.timer.Tick += new System.EventHandler(this.timer_Tick);
      // 
      // FormUserList
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(424, 276);
      this.Controls.Add(this.lv);
      this.Name = "FormUserList";
      this.Text = "User List";
      this.Closing += new System.ComponentModel.CancelEventHandler(this.FormUserList_Closing);
      this.Load += new System.EventHandler(this.FormUserList_Load);
      this.ResumeLayout(false);

    }
		#endregion

    public bool ClosingApp;

    protected override void WndProc(ref System.Windows.Forms.Message m)
    {
      if (m.Msg == WinMsg.WM_QUERYENDSESSION)
        m.Result = (IntPtr)1;
      else if (m.Msg == WinMsg.WM_ENDSESSION)
      {
        ClosingApp = true;
        Close();
      }
      else
        base.WndProc(ref m);
    }

    private void FormUserList_Closing(object sender, System.ComponentModel.CancelEventArgs e)
    {
      if (!ClosingApp)
      {
        e.Cancel = true;
        Hide();
      }
      else
        FormMain.Instance.FormUserList = null;
    }

    ArrayList m_arAI = new ArrayList();

    bool m_bUpdateView;

    void UpdateView()
    {
      lock (Messenger.Instance)
        lock (m_arAI)
        {
          for (int i=0; i<m_arAI.Count; i++)
          {
            AccountInfo ai = (AccountInfo)m_arAI[i];
            if (ai.AccountState == AccountState.Online)
              for (int j=0; j<i; j++)
                if (((AccountInfo)m_arAI[j]).AccountState != AccountState.Online)
                {
                  m_arAI[i] = m_arAI[j];
                  m_arAI[j] = ai;
                  break;
                }
          }
          lv.Items.Clear();
          foreach (AccountInfo ai in m_arAI)
          {
            ListViewItem li = new ListViewItem(ai.UpdateTime.ToString());
            li.SubItems.Add(ai.NickName);
            li.SubItems.Add(ai.FirstName);
            li.SubItems.Add(ai.LastName);
            li.SubItems.Add(ai.Email);
            li.ImageIndex = FormMain.GetStateImageIndex(ai.AccountState);
            li.Tag = ai;
            lv.Items.Add(li);
          }
        }
    }

    public void OnAccountInfo(object o, AccountInfo ai)
    {
      lock (m_arAI)
        m_arAI.Add(ai);
      m_bUpdateView = true;
      UnetMan.Instance.Relay(new QueryAccountStatePacket(ai));
    }

    void OnChangeContactState(object o, EventArgs e)
    {
      m_bUpdateView = true;
    }

    Messenger.ChangeContactStateHandler ChangeContactStateHandler;

    private void FormUserList_Load(object sender, System.EventArgs e)
    {
      lv.SmallImageList = FormMain.Instance.imageList;
      ChangeContactStateHandler = new Messenger.ChangeContactStateHandler(OnChangeContactState);
      Messenger.Instance.OnChangeContactState += ChangeContactStateHandler;
    }

    private void menuItemAdd_Click(object sender, System.EventArgs e)
    {
      foreach (ListViewItem li in lv.SelectedItems)
        FormMain.Instance.Messenger.AddToProfile((AccountInfo)li.Tag);
      FormMain.Instance.Messenger.Save();
      FormMain.Instance.UpdateView();
    }

    private void lv_DoubleClick(object sender, System.EventArgs e)
    {
      menuItemAdd_Click(null,null);    
    }

    private void menuItemProperties_Click(object sender, System.EventArgs e)
    {
      new FormAccountInfo((AccountInfo)lv.SelectedItems[0].Tag).Show();    
    }

    private void timer_Tick(object sender, System.EventArgs e)
    {
      if (m_bUpdateView)
      {
        m_bUpdateView = false;
        UpdateView();
      }
    }
	}
}
